﻿// dllmain.cpp : Определяет точку входа для приложения DLL.
#include "pch.h"
#include "IMenu.h"
#include <functional>
#include <deque>

ALT_LOG_IMPL;

bool playerChanged = false;
bool playerTeleported = false;

uint32_t vehicles[] = { 47200842, 87577242, 89913743, 93893176, 150966765, 164947977, 217912393, 219205323, 253923078, 265500599, 374792535, 405368030, 470870473, 479008570, 518773733, 546463094, 572854005, 583628516, 661519966, 703203753, 742064790, 749266870, 822759307, 944661538, 962088794, 1016623270, 1115303244, 1192745176, 1297830025, 1308722738, 1468884243, 1493442814, 1582724764, 1588640480, 1596452133, 1642867136, 1745694728, 1761016051, 1770617692, 1786827347, 1871675108, 1874711736, 1975376854, 1998899080, 2109471093, 2111085321, 2135054537, 2186197941, 2241085408, 2272161463, 2306418508, 2348950726, 2428834674, 2433126343, 2466530028, 2468662606, 2536874959, 2541765679, 2584352890, 2586870135, 2606273646, 2681649752, 2743460295, 2750181085, 2818287139, 2868816046, 2907791640, 2919595783, 2947683355, 2986591923, 3005186165, 3015988546, 3194579596, 3262735550, 3268542718, 3286679556, 3289055845, 3295963005, 3306145232, 3338296319, 3371110816, 3435547054, 3470709364, 3628942640, 3658820774, 3671853927, 3724275886, 3750150746, 3791540180, 3889770730, 3897453428, 3901912305, 3916234491, 3917809588, 3962179608, 3973572878, 3999552582, 4001518838, 4011804713, 4019278719, 4036476012, 4059979704, 4114212256, 4114498448, 4130514530, 4151691040, 4158133943, 4159216269 };
constexpr uint32_t vehiclesCount = sizeof(vehicles) / 4;

static std::wstring GetModulePath(HMODULE module)
{
	DWORD size = MAX_PATH;
	std::vector<wchar_t> buffer(size);

	do
	{
		buffer.resize(size);
		GetModuleFileNameW(module, buffer.data(), size);
		size *= 1.5;
	} while (GetLastError() == ERROR_INSUFFICIENT_BUFFER);

	std::wstring modulePath = std::wstring(buffer.begin(), buffer.end());

	size_t slashPos = modulePath.size();
	for (int i = modulePath.size() - 1; i >= 0; --i)
	{
		if (modulePath[i] == L'/' || modulePath[i] == L'\\') {
			slashPos = i;
			break;
		}
	}

	std::wstring moduleDir = modulePath.substr(0, slashPos);
	return moduleDir;
}

//We will imagine that our screen is 1920x1080. Default FullHD
void DrawGameRect(uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
	float fWidth = width / (float)1920;
	float fHeight = height / (float)1080;
	float fX = (x + width / 2) / (float)1920;
	float fY = (y + height / 2) / (float)1080;
	
	Native::Invoke<void, float, float, float, float, uint8_t, uint8_t, uint8_t, uint8_t, bool>(N::DRAW_RECT, fX, fY, fWidth, fHeight, r, g, b, a, true);
}

void DrawGameText(uint16_t x, uint16_t y, const char* text, uint8_t r, uint8_t g, uint8_t b, uint8_t a, float scaleX = 0.342f, float scaleY = 0.342f)
{
	float fX = x / (float)1920;
	float fY = y / (float)1080;
	Native::Invoke<void, float, float>(N::SET_TEXT_SCALE, scaleX, scaleY);//0.342f
	Native::Invoke<void, uint8_t, uint8_t, uint8_t, uint8_t>(0x50A41AD966910F03, r, g, b, a);
	const char* varString = Native::Invoke<const char*, int, const char*, const char*>(N::_CREATE_VAR_STRING, 10, "LITERAL_STRING", text);
	Native::Invoke<void, const char*, float, float>(0xD79334A4BB99BAD1, varString, fX, fY);
}

uint32_t myLastVehicle = 0;

using mlDeque = std::deque<std::pair<uint32_t, std::function<void(void)>>>;
mlDeque modelLoadQueue;

void LoadModel(uint32_t model, std::function<void(void)> callback)
{
	bool modelExist = Native::Invoke<bool, uint32_t>(N::IS_MODEL_VALID, model);
	if (modelExist)
	{
		modelLoadQueue.push_back({ model, callback });
	}
}

void RequestModel(uint32_t model)
{
	Native::Invoke<void, uint32_t>(N::REQUEST_MODEL, model);
}

bool HasModelLoaded(uint32_t model)
{
	return Native::Invoke<bool, uint32_t>(N::HAS_MODEL_LOADED, model);
}

void SpawnVehicle(const char* vehName)
{
	uint32_t model = String::Hash(vehName);
	if (myLastVehicle)
	{
		Native::Invoke<void, uint32_t*>(N::DELETE_VEHICLE, &myLastVehicle);
		myLastVehicle = 0;
	}
	uint32_t myPed = Native::Invoke<uint32_t, uint32_t>(N::GET_PLAYER_PED, 0);
	Vector3f myPos = Native::Invoke<Vector3f, uint32_t, bool>(N::GET_ENTITY_COORDS, myPed, false);

	myLastVehicle = Native::Invoke<uint32_t, uint32_t, float, float, float, float, bool, bool, bool, bool>(N::CREATE_VEHICLE, model, myPos.x + 2, myPos.y + 2, myPos.z + 0.5, 49.29f, true, true, false, false);
	Native::Invoke<void, uint32_t>(N::SET_MODEL_AS_NO_LONGER_NEEDED, model);
}

void SpawnPed(const char* pedName)
{
	uint32_t model = String::Hash(pedName);
	uint32_t myPed = Native::Invoke<uint32_t, uint32_t>(N::GET_PLAYER_PED, 0);
	Vector3f myPos = Native::Invoke<Vector3f, uint32_t, bool>(N::GET_ENTITY_COORDS, myPed, false);

	uint32_t createdPed = Native::Invoke<uint32_t, uint32_t, float, float, float, float, bool, bool, bool, bool, bool, bool>(N::CREATE_PED, model, myPos.x + 1, myPos.y + 1, myPos.z, 0.f, false, false, false, false, true, true);
	Native::Invoke<void, uint32_t, bool>(N::SET_ENTITY_VISIBLE, createdPed, true);
	Native::Invoke<void, uint32_t, int, bool>(N::SET_ENTITY_ALPHA, createdPed, 255, false);
	Native::Invoke<void, uint32_t, bool>(0x283978A15512B2FE, createdPed, true);
	Native::Invoke<void, uint32_t>(N::SET_MODEL_AS_NO_LONGER_NEEDED, model);
}

void ChangePlayerModel(const char* modelName)
{
	uint32_t model = String::Hash(modelName);
	uint32_t myPed = Native::Invoke<uint32_t, uint32_t>(N::GET_PLAYER_PED, 0);

	Native::Invoke<void, uint32_t, uint32_t, bool>(N::SET_PLAYER_MODEL, myPed, model, false);
	Native::Invoke<void, uint32_t>(N::SET_MODEL_AS_NO_LONGER_NEEDED, model);
}

void TeleportPlayer(float x, float y, float z)
{
	uint32_t myPed = Native::Invoke<uint32_t, uint32_t>(N::GET_PLAYER_PED, 0);
	Native::Invoke<void, uint32_t, float, float, float, bool, bool, bool, bool>(N::SET_ENTITY_COORDS_NO_OFFSET, myPed, x, y, z, false, false, false, false);
}

void SetWeather(const char* weather)
{
	Native::Invoke<void, uint32_t, uint32_t, float, bool>(N::_SET_WEATHER_TYPE_TRANSITION, String::Hash(weather), String::Hash(weather), 0.5f, true);
}

void AddToClockTime(int hours, int minutes, int seconds)
{
	Native::Invoke<void, int, int, int>(N::ADD_TO_CLOCK_TIME, hours, minutes, seconds);
}

std::function<void()> GetSpawnPed(const char* model)
{ 
	return [model] { 
		LoadModel(String::Hash(model), [model] {
			SpawnPed(model);
		});
	};
}

std::function<void()> GetChangePlayerModel(const char* model)
{
	return [model] {
		LoadModel(String::Hash(model), [model] {
			ChangePlayerModel(model);
		});
	};
}

std::function<void()> GetAddToClockTime(int hours, int minutes, int seconds)
{
	return [hours, minutes, seconds] {
		AddToClockTime(hours, minutes, seconds);
	};
}
std::function<void()> GetSetWeather(const char* weather) {
	return [weather] {
		SetWeather(weather);
	};
}

std::function<void()> GetTeleportPlayer(float x, float y, float z)
{
	return [x, y, z] {
		TeleportPlayer(x, y, z);
	};
}

std::function<void()> GetSpawnVehicle(const char* vehName)
{
	return [vehName] {
		LoadModel(String::Hash(vehName), [vehName] {
			SpawnVehicle(vehName);
		});
	};
}

IMenu* currentMenu = nullptr;
int32_t menuCursor = 0;
bool menuEnabled = true;

void TickCpp()
{
	if (menuEnabled)
	{
		DrawGameRect(100, 48, 500, 50, 200, 200, 0, 200);
		DrawGameText(105, 53, currentMenu->GetTitle().c_str(), 255, 255, 255, 255);

		const std::vector<IMenu*>& items = currentMenu->GetChildItems();

		int from = 0;
		int to = 0;

		int offset = 0;
		if (menuCursor < 6)
		{
			if (currentMenu->GetType() == eMenuType::SUB_MENU)
			{
				DrawGameRect(100, 100, 500, 35, 200, 200, 0, menuCursor == 0 ? 255 : 150);
				DrawGameText(105, 105, "<< BACK >>", 255, 255, 255, 255);
				offset++;
			}
			from = 0;
			to = (items.size() < 11 ? items.size() : 11);
		}
		else if (menuCursor >= 6 && menuCursor <= (items.size() - 6))
		{
			from = menuCursor - 6;
			to = menuCursor + 6;
		}
		else
		{
			from = items.size() - 12;
			to = items.size();
		}

		for (int i = from; i < to; ++i, ++offset)
		{
			DrawGameRect(100, 100 + 37 * offset, 500, 35, 200, 0, 0, menuCursor == (i + (int)(currentMenu->GetType() == eMenuType::SUB_MENU)) ? 255 : 150);
			DrawGameText(105, 105 + 37 * offset, items[i]->GetTitle().c_str(), 255, 255, 255, 255);
		}
	}
	
	for (int i = 0; i < modelLoadQueue.size(); ++i)
	{
		auto& it = modelLoadQueue[i];
		if (HasModelLoaded(it.first))
		{
			auto callbackFunc = it.second;
			callbackFunc();
			modelLoadQueue.erase(modelLoadQueue.begin() + i, modelLoadQueue.begin() + i + 1);
			--i;
		}
		else
			RequestModel(it.first);
	}
}

uint32_t currentVehNr = 0;

extern "C" {
	DLL_EXPORT void Init(GetNativeAddressFunc getAddress)
	{
		Native::SetEssentialFunction(getAddress);
		Log::Info << "Natives registered" << Log::Endl;

		CMainMenu* mainMenu = new CMainMenu("TRAINER MENU");
		currentMenu = mainMenu;

		CSubMenu* vehiclesMenu = new CSubMenu("VEHICLES", mainMenu);
		vehiclesMenu->AddChildItem(new CMenuAction("privateopensleeper02x", GetSpawnVehicle("privateopensleeper02x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateopensleeper01x", GetSpawnVehicle("privateopensleeper01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("steamerDummy", GetSpawnVehicle("steamerDummy")));
		vehiclesMenu->AddChildItem(new CMenuAction("armoredCar01x", GetSpawnVehicle("armoredCar01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("armoredCar03x", GetSpawnVehicle("armoredCar03x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privatebaggage01x", GetSpawnVehicle("privatebaggage01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("smuggler02", GetSpawnVehicle("smuggler02")));
		vehiclesMenu->AddChildItem(new CMenuAction("keelboat", GetSpawnVehicle("keelboat")));
		vehiclesMenu->AddChildItem(new CMenuAction("boatSteam02x", GetSpawnVehicle("boatSteam02x")));
		vehiclesMenu->AddChildItem(new CMenuAction("midlandrefrigeratorCar", GetSpawnVehicle("midlandrefrigeratorCar")));
		vehiclesMenu->AddChildItem(new CMenuAction("midlandboxcar05x", GetSpawnVehicle("midlandboxcar05x")));
		vehiclesMenu->AddChildItem(new CMenuAction("caboose01x", GetSpawnVehicle("caboose01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("canoe", GetSpawnVehicle("canoe")));
		vehiclesMenu->AddChildItem(new CMenuAction("canoeTreeTrunk", GetSpawnVehicle("canoeTreeTrunk")));
		vehiclesMenu->AddChildItem(new CMenuAction("cart01", GetSpawnVehicle("cart01")));
		vehiclesMenu->AddChildItem(new CMenuAction("cart02", GetSpawnVehicle("cart02")));
		vehiclesMenu->AddChildItem(new CMenuAction("cart03", GetSpawnVehicle("cart03")));
		vehiclesMenu->AddChildItem(new CMenuAction("cart04", GetSpawnVehicle("cart04")));
		vehiclesMenu->AddChildItem(new CMenuAction("cart05", GetSpawnVehicle("cart05")));
		vehiclesMenu->AddChildItem(new CMenuAction("cart06", GetSpawnVehicle("cart06")));
		vehiclesMenu->AddChildItem(new CMenuAction("cart07", GetSpawnVehicle("cart07")));
		vehiclesMenu->AddChildItem(new CMenuAction("cart08", GetSpawnVehicle("cart08")));
		vehiclesMenu->AddChildItem(new CMenuAction("coach2", GetSpawnVehicle("coach2")));
		vehiclesMenu->AddChildItem(new CMenuAction("coach3", GetSpawnVehicle("coach3")));
		vehiclesMenu->AddChildItem(new CMenuAction("coach3_cutscene", GetSpawnVehicle("coach3_cutscene")));
		vehiclesMenu->AddChildItem(new CMenuAction("coach4", GetSpawnVehicle("coach4")));
		vehiclesMenu->AddChildItem(new CMenuAction("coach5", GetSpawnVehicle("coach5")));
		vehiclesMenu->AddChildItem(new CMenuAction("coach6", GetSpawnVehicle("coach6")));
		vehiclesMenu->AddChildItem(new CMenuAction("buggy01", GetSpawnVehicle("buggy01")));
		vehiclesMenu->AddChildItem(new CMenuAction("buggy02", GetSpawnVehicle("buggy02")));
		vehiclesMenu->AddChildItem(new CMenuAction("buggy03", GetSpawnVehicle("buggy03")));
		vehiclesMenu->AddChildItem(new CMenuAction("ArmySupplyWagon", GetSpawnVehicle("ArmySupplyWagon")));
		vehiclesMenu->AddChildItem(new CMenuAction("chuckwagon000x", GetSpawnVehicle("chuckwagon000x")));
		vehiclesMenu->AddChildItem(new CMenuAction("supplywagon", GetSpawnVehicle("supplywagon")));
		vehiclesMenu->AddChildItem(new CMenuAction("supplywagon2", GetSpawnVehicle("supplywagon2")));
		vehiclesMenu->AddChildItem(new CMenuAction("logwagon", GetSpawnVehicle("logwagon")));
		vehiclesMenu->AddChildItem(new CMenuAction("logwagon2", GetSpawnVehicle("logwagon2")));
		vehiclesMenu->AddChildItem(new CMenuAction("coal_wagon", GetSpawnVehicle("coal_wagon")));
		vehiclesMenu->AddChildItem(new CMenuAction("chuckwagon002x", GetSpawnVehicle("chuckwagon002x")));
		vehiclesMenu->AddChildItem(new CMenuAction("gatling_gun", GetSpawnVehicle("gatling_gun")));
		vehiclesMenu->AddChildItem(new CMenuAction("gatlingMaxim02", GetSpawnVehicle("gatlingMaxim02")));
		vehiclesMenu->AddChildItem(new CMenuAction("handcart", GetSpawnVehicle("handcart")));
		vehiclesMenu->AddChildItem(new CMenuAction("horseBoat", GetSpawnVehicle("horseBoat")));
		vehiclesMenu->AddChildItem(new CMenuAction("hotAirBalloon01", GetSpawnVehicle("hotAirBalloon01")));
		vehiclesMenu->AddChildItem(new CMenuAction("hotchkiss_cannon", GetSpawnVehicle("hotchkiss_cannon")));
		vehiclesMenu->AddChildItem(new CMenuAction("mineCart01x", GetSpawnVehicle("mineCart01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("northflatcar01x", GetSpawnVehicle("northflatcar01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateflatcar01x", GetSpawnVehicle("privateflatcar01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("northpassenger01x", GetSpawnVehicle("northpassenger01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("northpassenger03x", GetSpawnVehicle("northpassenger03x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privatepassenger01x", GetSpawnVehicle("privatepassenger01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("oilWagon01x", GetSpawnVehicle("oilWagon01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("oilWagon02x", GetSpawnVehicle("oilWagon02x")));
		vehiclesMenu->AddChildItem(new CMenuAction("pirogue", GetSpawnVehicle("pirogue")));
		vehiclesMenu->AddChildItem(new CMenuAction("pirogue2", GetSpawnVehicle("pirogue2")));
		vehiclesMenu->AddChildItem(new CMenuAction("policeWagon01x", GetSpawnVehicle("policeWagon01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("policeWagongatling01x", GetSpawnVehicle("policeWagongatling01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateCoalCar01x", GetSpawnVehicle("privateCoalCar01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("NorthCoalCar01x", GetSpawnVehicle("NorthCoalCar01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("winterSteamer", GetSpawnVehicle("winterSteamer")));
		vehiclesMenu->AddChildItem(new CMenuAction("wintercoalcar", GetSpawnVehicle("wintercoalcar")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateboxcar04x", GetSpawnVehicle("privateboxcar04x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateboxcar02x", GetSpawnVehicle("privateboxcar02x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateboxcar01x", GetSpawnVehicle("privateboxcar01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("coalHopper01x", GetSpawnVehicle("coalHopper01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateObservationcar", GetSpawnVehicle("privateObservationcar")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateArmoured", GetSpawnVehicle("privateArmoured")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateDining01x", GetSpawnVehicle("privateDining01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateRooms01x", GetSpawnVehicle("privateRooms01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("privateSteamer01x", GetSpawnVehicle("privateSteamer01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("northSteamer01x", GetSpawnVehicle("northSteamer01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("GhostTrainSteamer", GetSpawnVehicle("GhostTrainSteamer")));
		vehiclesMenu->AddChildItem(new CMenuAction("GhostTrainCoalCar", GetSpawnVehicle("GhostTrainCoalCar")));
		vehiclesMenu->AddChildItem(new CMenuAction("GhostTrainPassenger", GetSpawnVehicle("GhostTrainPassenger")));
		vehiclesMenu->AddChildItem(new CMenuAction("GhostTrainCaboose", GetSpawnVehicle("GhostTrainCaboose")));
		vehiclesMenu->AddChildItem(new CMenuAction("rcBoat", GetSpawnVehicle("rcBoat")));
		vehiclesMenu->AddChildItem(new CMenuAction("rowboat", GetSpawnVehicle("rowboat")));
		vehiclesMenu->AddChildItem(new CMenuAction("rowboatSwamp", GetSpawnVehicle("rowboatSwamp")));
		vehiclesMenu->AddChildItem(new CMenuAction("rowboatSwamp02", GetSpawnVehicle("rowboatSwamp02")));
		vehiclesMenu->AddChildItem(new CMenuAction("ship_guama02", GetSpawnVehicle("ship_guama02")));
		vehiclesMenu->AddChildItem(new CMenuAction("turbineboat", GetSpawnVehicle("turbineboat")));
		vehiclesMenu->AddChildItem(new CMenuAction("ship_nbdGuama", GetSpawnVehicle("ship_nbdGuama")));
		vehiclesMenu->AddChildItem(new CMenuAction("ship_nbdGuama2", GetSpawnVehicle("ship_nbdGuama2")));
		vehiclesMenu->AddChildItem(new CMenuAction("skiff", GetSpawnVehicle("skiff")));
		vehiclesMenu->AddChildItem(new CMenuAction("stagecoach001x", GetSpawnVehicle("stagecoach001x")));
		vehiclesMenu->AddChildItem(new CMenuAction("stagecoach002x", GetSpawnVehicle("stagecoach002x")));
		vehiclesMenu->AddChildItem(new CMenuAction("stagecoach003x", GetSpawnVehicle("stagecoach003x")));
		vehiclesMenu->AddChildItem(new CMenuAction("stagecoach004x", GetSpawnVehicle("stagecoach004x")));
		vehiclesMenu->AddChildItem(new CMenuAction("stagecoach005x", GetSpawnVehicle("stagecoach005x")));
		vehiclesMenu->AddChildItem(new CMenuAction("stagecoach006x", GetSpawnVehicle("stagecoach006x")));
		vehiclesMenu->AddChildItem(new CMenuAction("trolley01x", GetSpawnVehicle("trolley01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("TugBoat2", GetSpawnVehicle("TugBoat2")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagon02x", GetSpawnVehicle("wagon02x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagon03x", GetSpawnVehicle("wagon03x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagon04x", GetSpawnVehicle("wagon04x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagon05x", GetSpawnVehicle("wagon05x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagon06x", GetSpawnVehicle("wagon06x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagonCircus01x", GetSpawnVehicle("wagonCircus01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagonCircus02x", GetSpawnVehicle("wagonCircus02x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagonDoc01x", GetSpawnVehicle("wagonDoc01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagonPrison01x", GetSpawnVehicle("wagonPrison01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagonWork01x", GetSpawnVehicle("wagonWork01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagonDairy01x", GetSpawnVehicle("wagonDairy01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("wagonTraveller01x", GetSpawnVehicle("wagonTraveller01x")));
		vehiclesMenu->AddChildItem(new CMenuAction("breach_cannon", GetSpawnVehicle("breach_cannon")));
		vehiclesMenu->AddChildItem(new CMenuAction("utilliwag", GetSpawnVehicle("utilliwag")));
		vehiclesMenu->AddChildItem(new CMenuAction("gatchuck", GetSpawnVehicle("gatchuck")));
		vehiclesMenu->AddChildItem(new CMenuAction("gatchuck_2", GetSpawnVehicle("gatchuck_2")));

		CSubMenu* changePlayerModel = new CSubMenu("!! CHANGE MODEL", mainMenu);
		changePlayerModel->AddChildItem(new CMenuAction("CS_BILLWILLIAMSON", GetChangePlayerModel("CS_BILLWILLIAMSON")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_MICAHBELL", GetChangePlayerModel("CS_MICAHBELL")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_UNCLE", GetChangePlayerModel("CS_UNCLE")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_SEAN", GetChangePlayerModel("CS_SEAN")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_KIERAN", GetChangePlayerModel("CS_KIERAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_WapWarriors_01", GetChangePlayerModel("A_M_M_WapWarriors_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_O_WapTownfolk_01", GetChangePlayerModel("A_M_O_WapTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_O_WapTownfolk_01", GetChangePlayerModel("A_F_O_WapTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_WAPOFFICIAL_01", GetChangePlayerModel("U_M_M_WAPOFFICIAL_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_WAPWARRIORS_01", GetChangePlayerModel("A_M_M_WAPWARRIORS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_O_WAPTOWNFOLK_01", GetChangePlayerModel("A_M_O_WAPTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_UNITRAINENGINEER_01", GetChangePlayerModel("S_M_M_UNITRAINENGINEER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_UNITRAINGUARDS_01", GetChangePlayerModel("S_M_M_UNITRAINGUARDS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_MiddleTrainPassengers_01", GetChangePlayerModel("A_M_M_MiddleTrainPassengers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_MiddleTrainPassengers_01", GetChangePlayerModel("A_F_M_MiddleTrainPassengers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_LowerTrainPassengers_01", GetChangePlayerModel("A_M_M_LowerTrainPassengers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_LowerTrainPassengers_01", GetChangePlayerModel("A_F_M_LowerTrainPassengers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_UpperTrainPassengers_01", GetChangePlayerModel("A_M_M_UpperTrainPassengers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_UpperTrainPassengers_01", GetChangePlayerModel("A_F_M_UpperTrainPassengers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_NBXUPPERCLASS_01", GetChangePlayerModel("A_M_M_NBXUPPERCLASS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_NBXUPPERCLASS_01", GetChangePlayerModel("A_F_M_NBXUPPERCLASS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UNIDUSTER_02", GetChangePlayerModel("G_M_M_UNIDUSTER_02")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UNIDUSTER_03", GetChangePlayerModel("G_M_M_UNIDUSTER_03")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_EDMUNDLOWRY", GetChangePlayerModel("CS_EDMUNDLOWRY")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UniBanditos_01", GetChangePlayerModel("G_M_M_UniBanditos_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_POISONWELLSHAMAN", GetChangePlayerModel("CS_POISONWELLSHAMAN")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_RACRAILGUARDS_01", GetChangePlayerModel("S_M_M_RACRAILGUARDS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_valbarber_01", GetChangePlayerModel("U_M_M_valbarber_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ValBartender_01", GetChangePlayerModel("U_M_M_ValBartender_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ValDoctor_01", GetChangePlayerModel("U_M_M_ValDoctor_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ValGunsmith_01", GetChangePlayerModel("U_M_M_ValGunsmith_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_VALSHERIFF", GetChangePlayerModel("CS_VALSHERIFF")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UNIDUSTER_01", GetChangePlayerModel("G_M_M_UNIDUSTER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_SDTICKETSELLER_01", GetChangePlayerModel("S_M_M_SDTICKETSELLER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_MagicLantern_01", GetChangePlayerModel("S_M_M_MagicLantern_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_GrizzledJon", GetChangePlayerModel("CS_GrizzledJon")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_VALCRIMINALS_01", GetChangePlayerModel("A_M_M_VALCRIMINALS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ASBMINER_02", GetChangePlayerModel("A_M_M_ASBMINER_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_Y_ASBMINER_02", GetChangePlayerModel("A_M_Y_ASBMINER_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ASBMINER_04", GetChangePlayerModel("A_M_M_ASBMINER_04")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_Y_ASBMINER_04", GetChangePlayerModel("A_M_Y_ASBMINER_04")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ASBMINER_03", GetChangePlayerModel("A_M_M_ASBMINER_03")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_Y_ASBMINER_03", GetChangePlayerModel("A_M_Y_ASBMINER_03")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_JamesonGuard_01", GetChangePlayerModel("A_M_M_JamesonGuard_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_ASBSHERIFF_01", GetChangePlayerModel("U_M_O_ASBSHERIFF_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RkrFancyDRIVERS_01", GetChangePlayerModel("A_M_M_RkrFancyDRIVERS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RkrFancyTravellers_01", GetChangePlayerModel("A_M_M_RkrFancyTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_RkrFancyTravellers_01", GetChangePlayerModel("A_F_M_RkrFancyTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_CornwallGuard_01", GetChangePlayerModel("S_M_M_CornwallGuard_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UniCornwallGoons_01", GetChangePlayerModel("G_M_M_UniCornwallGoons_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_CRDHOMESTEADTENANT_01", GetChangePlayerModel("U_M_M_CRDHOMESTEADTENANT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_CRDHOMESTEADTENANT_02", GetChangePlayerModel("U_M_M_CRDHOMESTEADTENANT_02")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_PSHRANCHER_01", GetChangePlayerModel("U_M_O_PSHRANCHER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_CAJHOMESTEAD_01", GetChangePlayerModel("U_M_O_CAJHOMESTEAD_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_Y_CAJHOMESTEAD_01", GetChangePlayerModel("U_M_Y_CAJHOMESTEAD_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_CAJHOMESTEAD_01", GetChangePlayerModel("U_M_M_CAJHOMESTEAD_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_DOROETHEAWICKLOW", GetChangePlayerModel("CS_DOROETHEAWICKLOW")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_AmbientSDPolice_01", GetChangePlayerModel("S_M_M_AmbientSDPolice_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_SDObeseMen_01", GetChangePlayerModel("A_M_M_SDObeseMen_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_SDObeseWomen_01", GetChangePlayerModel("A_F_M_SDObeseWomen_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_NBXShadyDealer_01", GetChangePlayerModel("U_M_M_NBXShadyDealer_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_WapTownfolk_01", GetChangePlayerModel("A_F_M_WapTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_SDLABORERS_02", GetChangePlayerModel("A_M_M_SDLABORERS_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_Y_NBXSTREETKIDS_01", GetChangePlayerModel("A_M_Y_NBXSTREETKIDS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_LowerSDTownfolk_02", GetChangePlayerModel("A_M_M_LowerSDTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_LowerSDTownfolk_01", GetChangePlayerModel("A_M_M_LowerSDTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_Y_NbxStreetKids_Slums_01", GetChangePlayerModel("A_M_Y_NbxStreetKids_Slums_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_Y_SDStreetKids_Slums_02", GetChangePlayerModel("A_M_Y_SDStreetKids_Slums_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_SDDockWorkers_02", GetChangePlayerModel("A_M_M_SDDockWorkers_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_SDDockForeman_01", GetChangePlayerModel("A_M_M_SDDockForeman_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_NbxSlums_01", GetChangePlayerModel("A_F_M_NbxSlums_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_SDSlums_02", GetChangePlayerModel("A_F_M_SDSlums_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_NbxSlums_01", GetChangePlayerModel("A_M_M_NbxSlums_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_SDSlums_02", GetChangePlayerModel("A_M_M_SDSlums_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_O_SDUpperClass_01", GetChangePlayerModel("A_M_O_SDUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_NbxUpperClass_01", GetChangePlayerModel("A_F_M_NbxUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_O_SDUpperClass_01", GetChangePlayerModel("A_F_O_SDUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_MiddleSDTownfolk_01", GetChangePlayerModel("A_M_M_MiddleSDTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_MiddleSDTownfolk_02", GetChangePlayerModel("A_M_M_MiddleSDTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_MiddleSDTownfolk_03", GetChangePlayerModel("A_M_M_MiddleSDTownfolk_03")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_MiddleSDTownfolk_01", GetChangePlayerModel("A_F_M_MiddleSDTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_MiddleSDTownfolk_02", GetChangePlayerModel("A_F_M_MiddleSDTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_LowerSDTownfolk_01", GetChangePlayerModel("A_F_M_LowerSDTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_LowerSDTownfolk_02", GetChangePlayerModel("A_F_M_LowerSDTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_LowerSDTownfolk_03", GetChangePlayerModel("A_F_M_LowerSDTownfolk_03")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_SDChinatown_01", GetChangePlayerModel("A_F_M_SDChinatown_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_O_SDChinatown_01", GetChangePlayerModel("A_F_O_SDChinatown_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_SDFancyWhore_01", GetChangePlayerModel("A_F_M_SDFancyWhore_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UNIBRONTEGOONS_01", GetChangePlayerModel("G_M_M_UNIBRONTEGOONS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_SDChinatown_01", GetChangePlayerModel("A_M_M_SDChinatown_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_O_SDChinatown_01", GetChangePlayerModel("A_M_O_SDChinatown_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_VALGUNSMITH_01", GetChangePlayerModel("U_M_M_VALGUNSMITH_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_VALGENSTOREOWNER_01", GetChangePlayerModel("U_M_M_VALGENSTOREOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ValButcher_01", GetChangePlayerModel("U_M_M_ValButcher_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_VALTOWNFOLK_01", GetChangePlayerModel("A_M_M_VALTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_VALDOCTOR_01", GetChangePlayerModel("U_M_M_VALDOCTOR_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_BANKCLERK_01", GetChangePlayerModel("S_M_M_BANKCLERK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ValHotelOwner_01", GetChangePlayerModel("U_M_M_ValHotelOwner_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_VALBARTENDER_01", GetChangePlayerModel("U_M_M_VALBARTENDER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_VALBARBER_01", GetChangePlayerModel("U_M_M_VALBARBER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_ValBartender_01", GetChangePlayerModel("U_M_O_ValBartender_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_NBXBARTENDER_02", GetChangePlayerModel("U_M_M_NBXBARTENDER_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BLWUPPERCLASS_01", GetChangePlayerModel("A_M_M_BLWUPPERCLASS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_NBXBARTENDER_01", GetChangePlayerModel("U_M_M_NBXBARTENDER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_MIDDLESDTOWNFOLK_01", GetChangePlayerModel("A_M_M_MIDDLESDTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_NBXGENERALSTOREOWNER_01", GetChangePlayerModel("U_M_M_NBXGENERALSTOREOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_NBXSHADYDEALER_01", GetChangePlayerModel("U_M_M_NBXSHADYDEALER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_TAILOR_01", GetChangePlayerModel("S_M_M_TAILOR_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_NBXGUNSMITH_01", GetChangePlayerModel("U_M_M_NBXGUNSMITH_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_SDDOCTOR_01", GetChangePlayerModel("CS_SDDOCTOR_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_LIVERYWORKER_01", GetChangePlayerModel("S_M_M_LIVERYWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_MarketVendor_01", GetChangePlayerModel("S_M_M_MarketVendor_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_SDPhotographer_01", GetChangePlayerModel("U_M_M_SDPhotographer_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_STRGENSTOREOWNER_01", GetChangePlayerModel("U_M_M_STRGENSTOREOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_STRFREIGHTSTATIONOWNER_01", GetChangePlayerModel("U_M_M_STRFREIGHTSTATIONOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ASBGUNSMITH_01", GetChangePlayerModel("U_M_M_ASBGUNSMITH_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_SDTRAPPER_01", GetChangePlayerModel("U_M_M_SDTRAPPER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_TRAINSTATIONWORKER_01", GetChangePlayerModel("S_M_M_TRAINSTATIONWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_LAGTOWNFOLK_01", GetChangePlayerModel("A_F_M_LAGTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_SKPGUARD_01", GetChangePlayerModel("S_M_M_SKPGUARD_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_SKPPRISONER_01", GetChangePlayerModel("A_M_M_SKPPRISONER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_F_M_LagMother_01", GetChangePlayerModel("U_F_M_LagMother_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_O_LagTownfolk_01", GetChangePlayerModel("A_F_O_LagTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_O_LagTownfolk_01", GetChangePlayerModel("A_M_O_LagTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RHDFOREMAN_01", GetChangePlayerModel("A_M_M_RHDFOREMAN_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ORPGUARD_01", GetChangePlayerModel("U_M_M_ORPGUARD_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_ABE", GetChangePlayerModel("CS_ABE")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_DavidGeddes", GetChangePlayerModel("CS_DavidGeddes")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_ANGUSGEDDES", GetChangePlayerModel("CS_ANGUSGEDDES")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_DUNCANGEDDES", GetChangePlayerModel("CS_DUNCANGEDDES")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_MRSGEDDES", GetChangePlayerModel("CS_MRSGEDDES")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UNIMOUNTAINMEN_01", GetChangePlayerModel("G_M_M_UNIMOUNTAINMEN_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_LagTownfolk_01", GetChangePlayerModel("A_F_M_LagTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_ThomasDown", GetChangePlayerModel("CS_ThomasDown")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_ArchieDown", GetChangePlayerModel("CS_ArchieDown")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_EDITHDOWN", GetChangePlayerModel("CS_EDITHDOWN")));
		changePlayerModel->AddChildItem(new CMenuAction("S_F_M_MaPWorker_01", GetChangePlayerModel("S_F_M_MaPWorker_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_StrTownfolk_01", GetChangePlayerModel("A_M_M_StrTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_STRLABORER_01", GetChangePlayerModel("A_M_M_STRLABORER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BynRoughTravellers_01", GetChangePlayerModel("A_M_M_BynRoughTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DOGPOODLE_01", GetChangePlayerModel("A_C_DOGPOODLE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_RHDCOWPOKE_01", GetChangePlayerModel("S_M_M_RHDCOWPOKE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_UniButchers_01", GetChangePlayerModel("S_M_M_UniButchers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_Y_NewspaperBoy_01", GetChangePlayerModel("S_M_Y_NewspaperBoy_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_RhdUpperClass_01", GetChangePlayerModel("A_F_M_RhdUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_RhdTownfolk_02", GetChangePlayerModel("A_F_M_RhdTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("a_m_m_rhdtownfolk_01_laborer", GetChangePlayerModel("a_m_m_rhdtownfolk_01_laborer")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_RHDTOWNFOLK_01", GetChangePlayerModel("A_F_M_RHDTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_RHDBARTENDER_01", GetChangePlayerModel("U_M_M_RHDBARTENDER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_RHDGUNSMITH_01", GetChangePlayerModel("U_M_M_RHDGUNSMITH_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_RHDGENSTOREOWNER_01", GetChangePlayerModel("U_M_M_RHDGENSTOREOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_RHDGENSTOREOWNER_02", GetChangePlayerModel("U_M_M_RHDGENSTOREOWNER_02")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_RHDSHERIFF_01", GetChangePlayerModel("U_M_M_RHDSHERIFF_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_RHDTRAINSTATIONWORKER_01", GetChangePlayerModel("U_M_M_RHDTRAINSTATIONWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_RHDPROSTITUTE_01", GetChangePlayerModel("A_F_M_RHDPROSTITUTE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RHDObeseMen_01", GetChangePlayerModel("A_M_M_RHDObeseMen_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RhdUpperClass_01", GetChangePlayerModel("A_M_M_RhdUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RkrRoughTravellers_01", GetChangePlayerModel("A_M_M_RkrRoughTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DOGCATAHOULACUR_01", GetChangePlayerModel("A_C_DOGCATAHOULACUR_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_VHTTOWNFOLK_01", GetChangePlayerModel("A_F_M_VHTTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_VHTTHUG_01", GetChangePlayerModel("A_M_M_VHTTHUG_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_VHTSTATIONCLERK_01", GetChangePlayerModel("U_M_M_VHTSTATIONCLERK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_VHTEXOTICSHOPKEEPER_01", GetChangePlayerModel("U_M_O_VHTEXOTICSHOPKEEPER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_F_M_VhTBartender_01", GetChangePlayerModel("U_F_M_VhTBartender_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_HtlFancyDRIVERS_01", GetChangePlayerModel("A_M_M_HtlFancyDRIVERS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_HtlFancyTravellers_01", GetChangePlayerModel("A_M_M_HtlFancyTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_HtlFancyTravellers_01", GetChangePlayerModel("A_F_M_HtlFancyTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_BARBER_01", GetChangePlayerModel("S_M_M_BARBER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_UNIBUTCHERS_01", GetChangePlayerModel("S_M_M_UNIBUTCHERS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_BLWCOWPOKE_01", GetChangePlayerModel("S_M_M_BLWCOWPOKE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BLWObeseMen_01", GetChangePlayerModel("A_M_M_BLWObeseMen_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_O_BlWUpperClass_01", GetChangePlayerModel("A_M_O_BlWUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_BlWUpperClass_01", GetChangePlayerModel("A_F_M_BlWUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_O_BlWUpperClass_01", GetChangePlayerModel("A_F_O_BlWUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BlWLaborer_02", GetChangePlayerModel("A_M_M_BlWLaborer_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BlWLaborer_01", GetChangePlayerModel("A_M_M_BlWLaborer_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BlWForeman_01", GetChangePlayerModel("A_M_M_BlWForeman_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_BlWTownfolk_02", GetChangePlayerModel("A_F_M_BlWTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_BlWTownfolk_01", GetChangePlayerModel("A_F_M_BlWTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_AmbientBlWPolice_01", GetChangePlayerModel("S_M_M_AmbientBlWPolice_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_FussarHenchman_01", GetChangePlayerModel("S_M_M_FussarHenchman_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_GuaTownfolk_01", GetChangePlayerModel("A_F_M_GuaTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_O_GuaTownfolk_01", GetChangePlayerModel("A_F_O_GuaTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_GuaTownfolk_01", GetChangePlayerModel("A_M_M_GuaTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_O_GuaTownfolk_01", GetChangePlayerModel("A_M_O_GuaTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_NicholasTimmins", GetChangePlayerModel("CS_NicholasTimmins")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_STRFANCYTOURIST_01", GetChangePlayerModel("A_M_M_STRFANCYTOURIST_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_BiVFancyTravellers_01", GetChangePlayerModel("A_F_M_BiVFancyTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_STRTOWNFOLK_01", GetChangePlayerModel("A_F_M_STRTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_UNIGUNSLINGER_01", GetChangePlayerModel("A_M_M_UNIGUNSLINGER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_StrGenStoreOwner_01", GetChangePlayerModel("U_M_M_StrGenStoreOwner_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_STRWELCOMECENTER_01", GetChangePlayerModel("U_M_M_STRWELCOMECENTER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_STRSHERRIFF_01", GetChangePlayerModel("U_M_M_STRSHERRIFF_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_StrFreightStationOwner_01", GetChangePlayerModel("U_M_M_StrFreightStationOwner_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UNICRIMINALS_01", GetChangePlayerModel("G_M_M_UNICRIMINALS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UNICRIMINALS_02", GetChangePlayerModel("G_M_M_UNICRIMINALS_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BTCObeseMen_01", GetChangePlayerModel("A_M_M_BTCObeseMen_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_BTCObeseWomen_01", GetChangePlayerModel("A_F_M_BTCObeseWomen_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_AsbTownfolk_01", GetChangePlayerModel("A_M_M_AsbTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_AsbTownfolk_01", GetChangePlayerModel("A_F_M_AsbTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_BTCHILLBILLY_01", GetChangePlayerModel("A_F_M_BTCHILLBILLY_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_O_BTCHILLBILLY_01", GetChangePlayerModel("A_F_O_BTCHILLBILLY_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BTCHILLBILLY_01", GetChangePlayerModel("A_M_M_BTCHILLBILLY_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UniBraithwaites_01", GetChangePlayerModel("G_M_M_UniBraithwaites_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_CmrCivilwarcommando_01", GetChangePlayerModel("U_M_O_CmrCivilwarcommando_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_Army_01", GetChangePlayerModel("S_M_M_Army_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_BWMSTABLEHAND_01", GetChangePlayerModel("U_M_M_BWMSTABLEHAND_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_CGHWORKER_01", GetChangePlayerModel("S_M_M_CGHWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UniGrays_01", GetChangePlayerModel("G_M_M_UniGrays_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_O_UniExConfeds_01", GetChangePlayerModel("G_M_O_UniExConfeds_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_Y_UniExConfeds_01", GetChangePlayerModel("G_M_Y_UniExConfeds_01")));
		changePlayerModel->AddChildItem(new CMenuAction("G_M_M_UNIINBRED_01", GetChangePlayerModel("G_M_M_UNIINBRED_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_AberdeenSister", GetChangePlayerModel("CS_AberdeenSister")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_GriRoughTravellers_01", GetChangePlayerModel("A_M_M_GriRoughTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_ValTownfolk_01", GetChangePlayerModel("A_F_M_ValTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_F_O_WTCTOWNFOLK_01", GetChangePlayerModel("U_F_O_WTCTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_BLWTRAINSTATIONWORKER_01", GetChangePlayerModel("U_M_M_BLWTRAINSTATIONWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_BLWPHOTOGRAPHER", GetChangePlayerModel("CS_BLWPHOTOGRAPHER")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BlWTownfolk_01", GetChangePlayerModel("A_M_M_BlWTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_BLWPOLICECHIEF_01", GetChangePlayerModel("U_M_O_BLWPOLICECHIEF_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_Tailor_01", GetChangePlayerModel("S_M_M_Tailor_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_BankClerk_01", GetChangePlayerModel("S_M_M_BankClerk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_BLWBARTENDER_01", GetChangePlayerModel("U_M_O_BLWBARTENDER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_BLWGENERALSTOREOWNER_01", GetChangePlayerModel("U_M_O_BLWGENERALSTOREOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_TumDeputies_01", GetChangePlayerModel("S_M_M_TumDeputies_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_SHERIFFFREEMAN", GetChangePlayerModel("CS_SHERIFFFREEMAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_NEAROUGHTRAVELLERS_01", GetChangePlayerModel("A_M_M_NEAROUGHTRAVELLERS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_TumTownfolk_01", GetChangePlayerModel("A_M_M_TumTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_TumTownfolk_01", GetChangePlayerModel("A_F_M_TumTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_TumTownfolk_02", GetChangePlayerModel("A_M_M_TumTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_TumTownfolk_02", GetChangePlayerModel("A_F_M_TumTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_TUMBARTENDER_01", GetChangePlayerModel("U_M_M_TUMBARTENDER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_TUMBUTCHER_01", GetChangePlayerModel("U_M_M_TUMBUTCHER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_TUMGUNSMITH_01", GetChangePlayerModel("U_M_M_TUMGUNSMITH_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_F_M_TUMGENERALSTOREOWNER_01", GetChangePlayerModel("U_F_M_TUMGENERALSTOREOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ARMTOWNFOLK_01", GetChangePlayerModel("A_M_M_ARMTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RANCHERTRAVELERS_WARM_01", GetChangePlayerModel("A_M_M_RANCHERTRAVELERS_WARM_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_AmbientLawRural_01", GetChangePlayerModel("S_M_M_AmbientLawRural_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ArmCholeraCorpse_01", GetChangePlayerModel("A_M_M_ArmCholeraCorpse_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_ArmCholeraCorpse_01", GetChangePlayerModel("A_F_M_ArmCholeraCorpse_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ARMGENERALSTOREOWNER_01", GetChangePlayerModel("U_M_M_ARMGENERALSTOREOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_O_ARMBARTENDER_01", GetChangePlayerModel("U_M_O_ARMBARTENDER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ARMTRAINSTATIONWORKER_01", GetChangePlayerModel("U_M_M_ARMTRAINSTATIONWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_ARMUNDERTAKER_01", GetChangePlayerModel("U_M_M_ARMUNDERTAKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("RE_DEADBODIES_MALE", GetChangePlayerModel("RE_DEADBODIES_MALE")));
		changePlayerModel->AddChildItem(new CMenuAction("RE_DEADBODIES_MALES_01", GetChangePlayerModel("RE_DEADBODIES_MALES_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_ArmTownfolk_01", GetChangePlayerModel("A_F_M_ArmTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_ArmTownfolk_02", GetChangePlayerModel("A_F_M_ArmTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ArmTownfolk_01", GetChangePlayerModel("A_M_M_ArmTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ArmTownfolk_02", GetChangePlayerModel("A_M_M_ArmTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_FAMILYTRAVELERS_WARM_01", GetChangePlayerModel("A_F_M_FAMILYTRAVELERS_WARM_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_WROBEL", GetChangePlayerModel("CS_WROBEL")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_CZPHOMESTEADFATHER_01", GetChangePlayerModel("U_M_M_CZPHOMESTEADFATHER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_F_Y_CZPHOMESTEADDAUGHTER_01", GetChangePlayerModel("U_F_Y_CZPHOMESTEADDAUGHTER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_Y_CZPHOMESTEADSON_01", GetChangePlayerModel("U_M_Y_CZPHOMESTEADSON_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_Y_CZPHOMESTEADSON_02", GetChangePlayerModel("U_M_Y_CZPHOMESTEADSON_02")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_Y_CZPHOMESTEADSON_03", GetChangePlayerModel("U_M_Y_CZPHOMESTEADSON_03")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_LRSHOMESTEADTENANT_01", GetChangePlayerModel("U_M_M_LRSHOMESTEADTENANT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_F_M_RKSHOMESTEADTENANT_01", GetChangePlayerModel("U_F_M_RKSHOMESTEADTENANT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_UNIEXCONFEDSBOUNTY_01", GetChangePlayerModel("U_M_M_UNIEXCONFEDSBOUNTY_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_WALGENERALSTOREOWNER_01", GetChangePlayerModel("U_M_M_WALGENERALSTOREOWNER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_TrainStationWorker_01", GetChangePlayerModel("S_M_M_TrainStationWorker_01")));
		changePlayerModel->AddChildItem(new CMenuAction("p_m_zero", GetChangePlayerModel("p_m_zero")));
		changePlayerModel->AddChildItem(new CMenuAction("P_M_THREE", GetChangePlayerModel("P_M_THREE")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_KIERAN", GetChangePlayerModel("A_C_HORSE_GANG_KIERAN")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Dutch", GetChangePlayerModel("CS_Dutch")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_JackMarston", GetChangePlayerModel("CS_JackMarston")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_JACKMARSTON_TEEN", GetChangePlayerModel("CS_JACKMARSTON_TEEN")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_EagleFlies", GetChangePlayerModel("CS_EagleFlies")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Cleet", GetChangePlayerModel("CS_Cleet")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Joe", GetChangePlayerModel("CS_Joe")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_CREOLECAPTAIN", GetChangePlayerModel("CS_CREOLECAPTAIN")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_JosiahTrelawny", GetChangePlayerModel("CS_JosiahTrelawny")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_RevSwanson", GetChangePlayerModel("CS_RevSwanson")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_LeoStrauss", GetChangePlayerModel("CS_LeoStrauss")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_MrPearson", GetChangePlayerModel("CS_MrPearson")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Lenny", GetChangePlayerModel("CS_Lenny")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Sean", GetChangePlayerModel("CS_Sean")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_HoseaMatthews", GetChangePlayerModel("CS_HoseaMatthews")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_JavierEscuella", GetChangePlayerModel("CS_JavierEscuella")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_CharlesSmith", GetChangePlayerModel("CS_CharlesSmith")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Uncle", GetChangePlayerModel("CS_Uncle")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_BillWilliamson", GetChangePlayerModel("CS_BillWilliamson")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_MicahBell", GetChangePlayerModel("CS_MicahBell")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_JohnMarston", GetChangePlayerModel("CS_JohnMarston")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_AbigailRoberts", GetChangePlayerModel("CS_AbigailRoberts")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_MaryBeth", GetChangePlayerModel("CS_MaryBeth")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_MollyOshea", GetChangePlayerModel("CS_MollyOshea")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_SusanGrimshaw", GetChangePlayerModel("CS_SusanGrimshaw")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Karen", GetChangePlayerModel("CS_Karen")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Tilly", GetChangePlayerModel("CS_Tilly")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_MrsAdler", GetChangePlayerModel("CS_MrsAdler")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_HtlRoughTravellers_01", GetChangePlayerModel("A_M_M_HtlRoughTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_SclRoughTravellers_01", GetChangePlayerModel("A_M_M_SclRoughTravellers_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_LnSWorker_01", GetChangePlayerModel("U_M_M_LnSWorker_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_LnSWorker_02", GetChangePlayerModel("U_M_M_LnSWorker_02")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_LnSWorker_03", GetChangePlayerModel("U_M_M_LnSWorker_03")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_LnSWorker_04", GetChangePlayerModel("U_M_M_LnSWorker_04")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_RKFRANCHER_01", GetChangePlayerModel("U_M_M_RKFRANCHER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_Rancher_01", GetChangePlayerModel("A_M_M_Rancher_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_MFRRANCHER_01", GetChangePlayerModel("U_M_M_MFRRANCHER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("EA_LCMP_DOGS", GetChangePlayerModel("EA_LCMP_DOGS")));
		changePlayerModel->AddChildItem(new CMenuAction("EA_LCMP_FOREMAN", GetChangePlayerModel("EA_LCMP_FOREMAN")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_BiVForeman_01", GetChangePlayerModel("U_M_M_BiVForeman_01")));
		changePlayerModel->AddChildItem(new CMenuAction("EA_HMSTD_FOREMAN", GetChangePlayerModel("EA_HMSTD_FOREMAN")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_HtlForeman_01", GetChangePlayerModel("U_M_M_HtlForeman_01")));
		changePlayerModel->AddChildItem(new CMenuAction("EA_HMSTD_WORKER_1", GetChangePlayerModel("EA_HMSTD_WORKER_1")));
		changePlayerModel->AddChildItem(new CMenuAction("EA_HMSTD_WORKER_2", GetChangePlayerModel("EA_HMSTD_WORKER_2")));
		changePlayerModel->AddChildItem(new CMenuAction("EA_HMSTD_MALE", GetChangePlayerModel("EA_HMSTD_MALE")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_HTLHusband_01", GetChangePlayerModel("U_M_M_HTLHusband_01")));
		changePlayerModel->AddChildItem(new CMenuAction("EA_HMSTD_FEMALE", GetChangePlayerModel("EA_HMSTD_FEMALE")));
		changePlayerModel->AddChildItem(new CMenuAction("U_F_M_HTLWife_01", GetChangePlayerModel("U_F_M_HTLWife_01")));
		changePlayerModel->AddChildItem(new CMenuAction("EA_RCAMP_FOREMAN", GetChangePlayerModel("EA_RCAMP_FOREMAN")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_RaCForeman_01", GetChangePlayerModel("U_M_M_RaCForeman_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_NbxUpperClass_01", GetChangePlayerModel("A_M_M_NbxUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BlWUpperClass_01", GetChangePlayerModel("A_M_M_BlWUpperClass_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_Kieran", GetChangePlayerModel("CS_Kieran")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RHDTOWNFOLK_02", GetChangePlayerModel("A_M_M_RHDTOWNFOLK_02")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_CKTWORKER_01", GetChangePlayerModel("S_M_M_CKTWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_STRLUMBERJACK_01", GetChangePlayerModel("S_M_M_STRLUMBERJACK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_RaCRailWorker_01", GetChangePlayerModel("S_M_M_RaCRailWorker_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_Y_RACRAILWORKER_01", GetChangePlayerModel("S_M_Y_RACRAILWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BIVWORKER_01", GetChangePlayerModel("A_M_M_BIVWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BLWTOWNFOLK_01", GetChangePlayerModel("A_M_M_BLWTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_MAPWORKER_01", GetChangePlayerModel("S_M_M_MAPWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_Y_HTLWORKER_01", GetChangePlayerModel("U_M_Y_HTLWORKER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_Y_HTLWORKER_02", GetChangePlayerModel("U_M_Y_HTLWORKER_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ASBMINER_01", GetChangePlayerModel("A_M_M_ASBMINER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_Y_ASBMINER_01", GetChangePlayerModel("A_M_Y_ASBMINER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_AberdeenPigFarmer", GetChangePlayerModel("CS_AberdeenPigFarmer")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_DORHOMESTEADHUSBAND_01", GetChangePlayerModel("U_M_M_DORHOMESTEADHUSBAND_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_EmRFarmHand_01", GetChangePlayerModel("A_M_M_EmRFarmHand_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_M_EMRFATHER_01", GetChangePlayerModel("U_M_M_EMRFATHER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("U_M_Y_EMRSON_01", GetChangePlayerModel("U_M_Y_EMRSON_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ValTownfolk_01", GetChangePlayerModel("A_M_M_ValTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ValFarmer_01", GetChangePlayerModel("A_M_M_ValFarmer_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ValTownfolk_02", GetChangePlayerModel("A_M_M_ValTownfolk_02")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_ValCowpoke_01", GetChangePlayerModel("S_M_M_ValCowpoke_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_ValLaborer_01", GetChangePlayerModel("A_M_M_ValLaborer_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_M_LiveryWorker_01", GetChangePlayerModel("S_M_M_LiveryWorker_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_NBXDOCKWORKERS_01", GetChangePlayerModel("A_M_M_NBXDOCKWORKERS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_NBXLABORERS_01", GetChangePlayerModel("A_M_M_NBXLABORERS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_LagTownfolk_01", GetChangePlayerModel("A_M_M_LagTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_BtcHillbilly_01", GetChangePlayerModel("A_M_M_BtcHillbilly_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_O_BTCHILLBILLY_01", GetChangePlayerModel("A_M_O_BTCHILLBILLY_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_VhtTownfolk_01", GetChangePlayerModel("A_M_M_VhtTownfolk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("CS_TomDickens", GetChangePlayerModel("CS_TomDickens")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_STRTOWNFOLK_01", GetChangePlayerModel("A_M_M_STRTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RHDTOWNFOLK_01", GetChangePlayerModel("A_M_M_RHDTOWNFOLK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_M_M_RhdForeman_01", GetChangePlayerModel("A_M_M_RhdForeman_01")));
		changePlayerModel->AddChildItem(new CMenuAction("S_M_Y_Army_01", GetChangePlayerModel("S_M_Y_Army_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_NbxWhore_01", GetChangePlayerModel("A_F_M_NbxWhore_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_VHTPROSTITUTE_01", GetChangePlayerModel("A_F_M_VHTPROSTITUTE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_F_M_VALPROSTITUTE_01", GetChangePlayerModel("A_F_M_VALPROSTITUTE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Cat_01", GetChangePlayerModel("A_C_Cat_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_CedarWaxwing_01", GetChangePlayerModel("A_C_CedarWaxwing_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Chipmunk_01", GetChangePlayerModel("A_C_Chipmunk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_CRAB_01", GetChangePlayerModel("A_C_CRAB_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Cormorant_01", GetChangePlayerModel("A_C_Cormorant_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_CarolinaParakeet_01", GetChangePlayerModel("A_C_CarolinaParakeet_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DogCatahoulaCur_01", GetChangePlayerModel("A_C_DogCatahoulaCur_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DOGHOBO_01", GetChangePlayerModel("A_C_DOGHOBO_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DOGHOUND_01", GetChangePlayerModel("A_C_DOGHOUND_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DogHusky_01", GetChangePlayerModel("A_C_DogHusky_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DOGRUFUS_01", GetChangePlayerModel("A_C_DOGRUFUS_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DOGBLUETICKCOONHOUND_01", GetChangePlayerModel("A_C_DOGBLUETICKCOONHOUND_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Donkey_01", GetChangePlayerModel("A_C_Donkey_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Elk_01", GetChangePlayerModel("A_C_Elk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHBULLHEADCAT_01_SM", GetChangePlayerModel("A_C_FISHBULLHEADCAT_01_SM")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHNORTHERNPIKE_01_LG", GetChangePlayerModel("A_C_FISHNORTHERNPIKE_01_LG")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHRAINBOWTROUT_01_MS", GetChangePlayerModel("A_C_FISHRAINBOWTROUT_01_MS")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHSALMONSOCKEYE_01_MS", GetChangePlayerModel("A_C_FISHSALMONSOCKEYE_01_MS")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_GILAMONSTER_01", GetChangePlayerModel("A_C_GILAMONSTER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Goat_01", GetChangePlayerModel("A_C_Goat_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANPAINT_GREYOVERO", GetChangePlayerModel("A_C_HORSE_AMERICANPAINT_GREYOVERO")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANSTANDARDBRED_PALOMINODAPPLE", GetChangePlayerModel("A_C_HORSE_AMERICANSTANDARDBRED_PALOMINODAPPLE")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANSTANDARDBRED_SILVERTAILBUCKSKIN", GetChangePlayerModel("A_C_HORSE_AMERICANSTANDARDBRED_SILVERTAILBUCKSKIN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_ANDALUSIAN_DARKBAY", GetChangePlayerModel("A_C_HORSE_ANDALUSIAN_DARKBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_ANDALUSIAN_ROSEGRAY", GetChangePlayerModel("A_C_HORSE_ANDALUSIAN_ROSEGRAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_APPALOOSA_BROWNLEOPARD", GetChangePlayerModel("A_C_HORSE_APPALOOSA_BROWNLEOPARD")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_APPALOOSA_LEOPARD", GetChangePlayerModel("A_C_HORSE_APPALOOSA_LEOPARD")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_ARABIAN_BLACK", GetChangePlayerModel("A_C_HORSE_ARABIAN_BLACK")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_ARABIAN_ROSEGREYBAY", GetChangePlayerModel("A_C_HORSE_ARABIAN_ROSEGREYBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_ARDENNES_BAYROAN", GetChangePlayerModel("A_C_HORSE_ARDENNES_BAYROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_ARDENNES_STRAWBERRYROAN", GetChangePlayerModel("A_C_HORSE_ARDENNES_STRAWBERRYROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_BELGIAN_BLONDCHESTNUT", GetChangePlayerModel("A_C_HORSE_BELGIAN_BLONDCHESTNUT")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_BELGIAN_MEALYCHESTNUT", GetChangePlayerModel("A_C_HORSE_BELGIAN_MEALYCHESTNUT")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_DUTCHWARMBLOOD_CHOCOLATEROAN", GetChangePlayerModel("A_C_HORSE_DUTCHWARMBLOOD_CHOCOLATEROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_DUTCHWARMBLOOD_SEALBROWN", GetChangePlayerModel("A_C_HORSE_DUTCHWARMBLOOD_SEALBROWN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_DUTCHWARMBLOOD_SOOTYBUCKSKIN", GetChangePlayerModel("A_C_HORSE_DUTCHWARMBLOOD_SOOTYBUCKSKIN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_HUNGARIANHALFBRED_DARKDAPPLEGREY", GetChangePlayerModel("A_C_HORSE_HUNGARIANHALFBRED_DARKDAPPLEGREY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_HUNGARIANHALFBRED_PIEBALDTOBIANO", GetChangePlayerModel("A_C_HORSE_HUNGARIANHALFBRED_PIEBALDTOBIANO")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MISSOURIFOXTROTTER_AMBERCHAMPAGNE", GetChangePlayerModel("A_C_HORSE_MISSOURIFOXTROTTER_AMBERCHAMPAGNE")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MISSOURIFOXTROTTER_SILVERDAPPLEPINTO", GetChangePlayerModel("A_C_HORSE_MISSOURIFOXTROTTER_SILVERDAPPLEPINTO")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_NOKOTA_REVERSEDAPPLEROAN", GetChangePlayerModel("A_C_HORSE_NOKOTA_REVERSEDAPPLEROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_SHIRE_DARKBAY", GetChangePlayerModel("A_C_HORSE_SHIRE_DARKBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_SHIRE_LIGHTGREY", GetChangePlayerModel("A_C_HORSE_SHIRE_LIGHTGREY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_SUFFOLKPUNCH_SORREL", GetChangePlayerModel("A_C_HORSE_SUFFOLKPUNCH_SORREL")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_SUFFOLKPUNCH_REDCHESTNUT", GetChangePlayerModel("A_C_HORSE_SUFFOLKPUNCH_REDCHESTNUT")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_FLAXENROAN", GetChangePlayerModel("A_C_HORSE_TENNESSEEWALKER_FLAXENROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_THOROUGHBRED_BRINDLE", GetChangePlayerModel("A_C_HORSE_THOROUGHBRED_BRINDLE")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_TURKOMAN_DARKBAY", GetChangePlayerModel("A_C_HORSE_TURKOMAN_DARKBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_TURKOMAN_GOLD", GetChangePlayerModel("A_C_HORSE_TURKOMAN_GOLD")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_TURKOMAN_SILVER", GetChangePlayerModel("A_C_HORSE_TURKOMAN_SILVER")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_BILL", GetChangePlayerModel("A_C_HORSE_GANG_BILL")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_CHARLES", GetChangePlayerModel("A_C_HORSE_GANG_CHARLES")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_DUTCH", GetChangePlayerModel("A_C_HORSE_GANG_DUTCH")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_HOSEA", GetChangePlayerModel("A_C_HORSE_GANG_HOSEA")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_JAVIER", GetChangePlayerModel("A_C_HORSE_GANG_JAVIER")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_JOHN", GetChangePlayerModel("A_C_HORSE_GANG_JOHN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_KAREN", GetChangePlayerModel("A_C_HORSE_GANG_KAREN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_LENNY", GetChangePlayerModel("A_C_HORSE_GANG_LENNY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_MICAH", GetChangePlayerModel("A_C_HORSE_GANG_MICAH")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_SADIE", GetChangePlayerModel("A_C_HORSE_GANG_SADIE")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_SEAN", GetChangePlayerModel("A_C_HORSE_GANG_SEAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_TRELAWNEY", GetChangePlayerModel("A_C_HORSE_GANG_TRELAWNEY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_UNCLE", GetChangePlayerModel("A_C_HORSE_GANG_UNCLE")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_SADIE_ENDLESSSUMMER", GetChangePlayerModel("A_C_HORSE_GANG_SADIE_ENDLESSSUMMER")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_CHARLES_ENDLESSSUMMER", GetChangePlayerModel("A_C_HORSE_GANG_CHARLES_ENDLESSSUMMER")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_GANG_UNCLE_ENDLESSSUMMER", GetChangePlayerModel("A_C_HORSE_GANG_UNCLE_ENDLESSSUMMER")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANPAINT_OVERO", GetChangePlayerModel("A_C_HORSE_AMERICANPAINT_OVERO")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANPAINT_TOBIANO", GetChangePlayerModel("A_C_HORSE_AMERICANPAINT_TOBIANO")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANPAINT_SPLASHEDWHITE", GetChangePlayerModel("A_C_HORSE_AMERICANPAINT_SPLASHEDWHITE")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANSTANDARDBRED_BLACK", GetChangePlayerModel("A_C_HORSE_AMERICANSTANDARDBRED_BLACK")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANSTANDARDBRED_BUCKSKIN", GetChangePlayerModel("A_C_HORSE_AMERICANSTANDARDBRED_BUCKSKIN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_APPALOOSA_BLANKET", GetChangePlayerModel("A_C_HORSE_APPALOOSA_BLANKET")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_APPALOOSA_LEOPARDBLANKET", GetChangePlayerModel("A_C_HORSE_APPALOOSA_LEOPARDBLANKET")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_ARABIAN_WHITE", GetChangePlayerModel("A_C_HORSE_ARABIAN_WHITE")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_HUNGARIANHALFBRED_FLAXENCHESTNUT", GetChangePlayerModel("A_C_HORSE_HUNGARIANHALFBRED_FLAXENCHESTNUT")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MUSTANG_GRULLODUN", GetChangePlayerModel("A_C_HORSE_MUSTANG_GRULLODUN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MUSTANG_WILDBAY", GetChangePlayerModel("A_C_HORSE_MUSTANG_WILDBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MUSTANG_TIGERSTRIPEDBAY", GetChangePlayerModel("A_C_HORSE_MUSTANG_TIGERSTRIPEDBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_NOKOTA_BLUEROAN", GetChangePlayerModel("A_C_HORSE_NOKOTA_BLUEROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_NOKOTA_WHITEROAN", GetChangePlayerModel("A_C_HORSE_NOKOTA_WHITEROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_THOROUGHBRED_BLOODBAY", GetChangePlayerModel("A_C_HORSE_THOROUGHBRED_BLOODBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_THOROUGHBRED_DAPPLEGREY", GetChangePlayerModel("A_C_HORSE_THOROUGHBRED_DAPPLEGREY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HorseMule_01", GetChangePlayerModel("A_C_HorseMule_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Ox_01", GetChangePlayerModel("A_C_Ox_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_REDFOOTEDBOOBY_01", GetChangePlayerModel("A_C_REDFOOTEDBOOBY_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SHARKHAMMERHEAD_01", GetChangePlayerModel("A_C_SHARKHAMMERHEAD_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SharkTiger", GetChangePlayerModel("A_C_SharkTiger")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SHEEP_01", GetChangePlayerModel("A_C_SHEEP_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SNAKEBLACKTAILRATTLE_01", GetChangePlayerModel("A_C_SNAKEBLACKTAILRATTLE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_snakeferdelance_01", GetChangePlayerModel("A_C_snakeferdelance_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_ROSEATESPOONBILL_01", GetChangePlayerModel("A_C_ROSEATESPOONBILL_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_TURKEY_01", GetChangePlayerModel("A_C_TURKEY_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_WOODPECKER_02", GetChangePlayerModel("A_C_WOODPECKER_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_PIG_01", GetChangePlayerModel("A_C_PIG_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SNAKEWATER_01", GetChangePlayerModel("A_C_SNAKEWATER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SPARROW_01", GetChangePlayerModel("A_C_SPARROW_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Egret_01", GetChangePlayerModel("A_C_Egret_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_PARROT_01", GetChangePlayerModel("A_C_PARROT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_PRAIRIECHICKEN_01", GetChangePlayerModel("A_C_PRAIRIECHICKEN_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_BAT_01", GetChangePlayerModel("A_C_BAT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Heron_01", GetChangePlayerModel("A_C_Heron_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Oriole_01", GetChangePlayerModel("A_C_Oriole_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_BLUEJAY_01", GetChangePlayerModel("A_C_BLUEJAY_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_CARDINAL_01", GetChangePlayerModel("A_C_CARDINAL_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Duck_01", GetChangePlayerModel("A_C_Duck_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_PIGEON", GetChangePlayerModel("A_C_PIGEON")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_ROBIN_01", GetChangePlayerModel("A_C_ROBIN_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SONGBIRD_01", GetChangePlayerModel("A_C_SONGBIRD_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Woodpecker_01", GetChangePlayerModel("A_C_Woodpecker_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_IGUANA_01", GetChangePlayerModel("A_C_IGUANA_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_ROOSTER_01", GetChangePlayerModel("A_C_ROOSTER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SNAKEFERDELANCE_01", GetChangePlayerModel("A_C_SNAKEFERDELANCE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Armadillo_01", GetChangePlayerModel("A_C_Armadillo_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_IGUANADESERT_01", GetChangePlayerModel("A_C_IGUANADESERT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Quail_01", GetChangePlayerModel("A_C_Quail_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SNAKEREDBOA_01", GetChangePlayerModel("A_C_SNAKEREDBOA_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Chicken_01", GetChangePlayerModel("A_C_Chicken_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FROGBULL_01", GetChangePlayerModel("A_C_FROGBULL_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SQUIRREL_01", GetChangePlayerModel("A_C_SQUIRREL_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Toad_01", GetChangePlayerModel("A_C_Toad_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_TURTLESNAPPING_01", GetChangePlayerModel("A_C_TURTLESNAPPING_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Bull_01", GetChangePlayerModel("A_C_Bull_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Cow", GetChangePlayerModel("A_C_Cow")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_MUSKRAT_01", GetChangePlayerModel("A_C_MUSKRAT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_RAT_01", GetChangePlayerModel("A_C_RAT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SNAKE_01", GetChangePlayerModel("A_C_SNAKE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Beaver_01", GetChangePlayerModel("A_C_Beaver_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_PHEASANT_01", GetChangePlayerModel("A_C_PHEASANT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Rabbit_01", GetChangePlayerModel("A_C_Rabbit_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_TurkeyWild_01", GetChangePlayerModel("A_C_TurkeyWild_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_BigHornRam_01", GetChangePlayerModel("A_C_BigHornRam_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Buck_01", GetChangePlayerModel("A_C_Buck_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Buffalo_01", GetChangePlayerModel("A_C_Buffalo_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DEER_01", GetChangePlayerModel("A_C_DEER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_ELK_01", GetChangePlayerModel("A_C_ELK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_MOOSE_01", GetChangePlayerModel("A_C_MOOSE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_ProngHorn_01", GetChangePlayerModel("A_C_ProngHorn_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MORGAN_BAY", GetChangePlayerModel("A_C_HORSE_MORGAN_BAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MORGAN_BAYROAN", GetChangePlayerModel("A_C_HORSE_MORGAN_BAYROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MORGAN_FLAXENCHESTNUT", GetChangePlayerModel("A_C_HORSE_MORGAN_FLAXENCHESTNUT")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_MORGAN_PALOMINO", GetChangePlayerModel("A_C_HORSE_MORGAN_PALOMINO")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_KENTUCKYSADDLE_BLACK", GetChangePlayerModel("A_C_HORSE_KENTUCKYSADDLE_BLACK")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_KENTUCKYSADDLE_CHESTNUTPINTO", GetChangePlayerModel("A_C_HORSE_KENTUCKYSADDLE_CHESTNUTPINTO")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_KENTUCKYSADDLE_GREY", GetChangePlayerModel("A_C_HORSE_KENTUCKYSADDLE_GREY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_KENTUCKYSADDLE_SILVERBAY", GetChangePlayerModel("A_C_HORSE_KENTUCKYSADDLE_SILVERBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_BLACKRABICANO", GetChangePlayerModel("A_C_HORSE_TENNESSEEWALKER_BLACKRABICANO")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_CHESTNUT", GetChangePlayerModel("A_C_HORSE_TENNESSEEWALKER_CHESTNUT")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_DAPPLEBAY", GetChangePlayerModel("A_C_HORSE_TENNESSEEWALKER_DAPPLEBAY")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_REDROAN", GetChangePlayerModel("A_C_HORSE_TENNESSEEWALKER_REDROAN")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_BEAR_01", GetChangePlayerModel("A_C_BEAR_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DOGAMERICANFOXHOUND_01", GetChangePlayerModel("A_C_DOGAMERICANFOXHOUND_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DOGCOLLIE_01", GetChangePlayerModel("A_C_DOGCOLLIE_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DogAustralianSheperd_01", GetChangePlayerModel("A_C_DogAustralianSheperd_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DogChesBayRetriever_01", GetChangePlayerModel("A_C_DogChesBayRetriever_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DogLab_01", GetChangePlayerModel("A_C_DogLab_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DogStreet_01", GetChangePlayerModel("A_C_DogStreet_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DogBlueTickCoonHound_01", GetChangePlayerModel("A_C_DogBlueTickCoonHound_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DogHound_01", GetChangePlayerModel("A_C_DogHound_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_TURTLESEA_01", GetChangePlayerModel("A_C_TURTLESEA_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HAWK_01", GetChangePlayerModel("A_C_HAWK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_DUCK_01", GetChangePlayerModel("A_C_DUCK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_LOON_01", GetChangePlayerModel("A_C_LOON_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_CORMORANT_01", GetChangePlayerModel("A_C_CORMORANT_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_GOOSECANADA_01", GetChangePlayerModel("A_C_GOOSECANADA_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_HERON_01", GetChangePlayerModel("A_C_HERON_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_EGRET_01", GetChangePlayerModel("A_C_EGRET_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_CraneWhooping_01", GetChangePlayerModel("A_C_CraneWhooping_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_PELICAN_01", GetChangePlayerModel("A_C_PELICAN_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Badger_01", GetChangePlayerModel("A_C_Badger_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_BOAR_01", GetChangePlayerModel("A_C_BOAR_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_JAVELINA_01", GetChangePlayerModel("A_C_JAVELINA_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_OWL_01", GetChangePlayerModel("A_C_OWL_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_PANTHER_01", GetChangePlayerModel("A_C_PANTHER_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_POSSUM_01", GetChangePlayerModel("A_C_POSSUM_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Raccoon_01", GetChangePlayerModel("A_C_Raccoon_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SKUNK_01", GetChangePlayerModel("A_C_SKUNK_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Alligator_01", GetChangePlayerModel("A_C_Alligator_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Alligator_02", GetChangePlayerModel("A_C_Alligator_02")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Alligator_03", GetChangePlayerModel("A_C_Alligator_03")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Bear_01", GetChangePlayerModel("A_C_Bear_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_BearBlack_01", GetChangePlayerModel("A_C_BearBlack_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Boar_01", GetChangePlayerModel("A_C_Boar_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_CALIFORNIACONDOR_01", GetChangePlayerModel("A_C_CALIFORNIACONDOR_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Cougar_01", GetChangePlayerModel("A_C_Cougar_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Coyote_01", GetChangePlayerModel("A_C_Coyote_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Crow_01", GetChangePlayerModel("A_C_Crow_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Eagle_01", GetChangePlayerModel("A_C_Eagle_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Fox_01", GetChangePlayerModel("A_C_Fox_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Hawk_01", GetChangePlayerModel("A_C_Hawk_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Owl_01", GetChangePlayerModel("A_C_Owl_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Panther_01", GetChangePlayerModel("A_C_Panther_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_RAVEN_01", GetChangePlayerModel("A_C_RAVEN_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_SEAGULL_01", GetChangePlayerModel("A_C_SEAGULL_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Vulture_01", GetChangePlayerModel("A_C_Vulture_01")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Wolf", GetChangePlayerModel("A_C_Wolf")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Wolf_Medium", GetChangePlayerModel("A_C_Wolf_Medium")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_Wolf_Small", GetChangePlayerModel("A_C_Wolf_Small")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FishMuskie_01_lg", GetChangePlayerModel("A_C_FishMuskie_01_lg")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHLAKESTURGEON_01_LG", GetChangePlayerModel("A_C_FISHLAKESTURGEON_01_LG")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHLONGNOSEGAR_01_LG", GetChangePlayerModel("A_C_FISHLONGNOSEGAR_01_LG")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHCHANNELCATFISH_01_LG", GetChangePlayerModel("A_C_FISHCHANNELCATFISH_01_LG")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHBLUEGIL_01_SM", GetChangePlayerModel("A_C_FISHBLUEGIL_01_SM")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHPERCH_01_SM", GetChangePlayerModel("A_C_FISHPERCH_01_SM")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHCHAINPICKEREL_01_SM", GetChangePlayerModel("A_C_FISHCHAINPICKEREL_01_SM")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHROCKBASS_01_SM", GetChangePlayerModel("A_C_FISHROCKBASS_01_SM")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHREDFINPICKEREL_01_SM", GetChangePlayerModel("A_C_FISHREDFINPICKEREL_01_SM")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHBLUEGIL_01_MS", GetChangePlayerModel("A_C_FISHBLUEGIL_01_MS")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHPERCH_01_MS", GetChangePlayerModel("A_C_FISHPERCH_01_MS")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHREDFINPICKEREL_01_MS", GetChangePlayerModel("A_C_FISHREDFINPICKEREL_01_MS")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHROCKBASS_01_MS", GetChangePlayerModel("A_C_FISHROCKBASS_01_MS")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHSMALLMOUTHBASS_01_MS", GetChangePlayerModel("A_C_FISHSMALLMOUTHBASS_01_MS")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHBULLHEADCAT_01_MS", GetChangePlayerModel("A_C_FISHBULLHEADCAT_01_MS")));
		changePlayerModel->AddChildItem(new CMenuAction("A_C_FISHLARGEMOUTHBASS_01_MS", GetChangePlayerModel("A_C_FISHLARGEMOUTHBASS_01_MS")));


		CSubMenu* spawnPedMenu = new CSubMenu("SPAWN PED", mainMenu);
		spawnPedMenu->AddChildItem(new CMenuAction("CS_BILLWILLIAMSON", GetSpawnPed("CS_BILLWILLIAMSON")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_MICAHBELL", GetSpawnPed("CS_MICAHBELL")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_UNCLE", GetSpawnPed("CS_UNCLE")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_SEAN", GetSpawnPed("CS_SEAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_KIERAN", GetSpawnPed("CS_KIERAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_WapWarriors_01", GetSpawnPed("A_M_M_WapWarriors_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_O_WapTownfolk_01", GetSpawnPed("A_M_O_WapTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_O_WapTownfolk_01", GetSpawnPed("A_F_O_WapTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_WAPOFFICIAL_01", GetSpawnPed("U_M_M_WAPOFFICIAL_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_WAPWARRIORS_01", GetSpawnPed("A_M_M_WAPWARRIORS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_O_WAPTOWNFOLK_01", GetSpawnPed("A_M_O_WAPTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_UNITRAINENGINEER_01", GetSpawnPed("S_M_M_UNITRAINENGINEER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_UNITRAINGUARDS_01", GetSpawnPed("S_M_M_UNITRAINGUARDS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_MiddleTrainPassengers_01", GetSpawnPed("A_M_M_MiddleTrainPassengers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_MiddleTrainPassengers_01", GetSpawnPed("A_F_M_MiddleTrainPassengers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_LowerTrainPassengers_01", GetSpawnPed("A_M_M_LowerTrainPassengers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_LowerTrainPassengers_01", GetSpawnPed("A_F_M_LowerTrainPassengers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_UpperTrainPassengers_01", GetSpawnPed("A_M_M_UpperTrainPassengers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_UpperTrainPassengers_01", GetSpawnPed("A_F_M_UpperTrainPassengers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_NBXUPPERCLASS_01", GetSpawnPed("A_M_M_NBXUPPERCLASS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_NBXUPPERCLASS_01", GetSpawnPed("A_F_M_NBXUPPERCLASS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UNIDUSTER_02", GetSpawnPed("G_M_M_UNIDUSTER_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UNIDUSTER_03", GetSpawnPed("G_M_M_UNIDUSTER_03")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_EDMUNDLOWRY", GetSpawnPed("CS_EDMUNDLOWRY")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UniBanditos_01", GetSpawnPed("G_M_M_UniBanditos_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_POISONWELLSHAMAN", GetSpawnPed("CS_POISONWELLSHAMAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_RACRAILGUARDS_01", GetSpawnPed("S_M_M_RACRAILGUARDS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_valbarber_01", GetSpawnPed("U_M_M_valbarber_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ValBartender_01", GetSpawnPed("U_M_M_ValBartender_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ValDoctor_01", GetSpawnPed("U_M_M_ValDoctor_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ValGunsmith_01", GetSpawnPed("U_M_M_ValGunsmith_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_VALSHERIFF", GetSpawnPed("CS_VALSHERIFF")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UNIDUSTER_01", GetSpawnPed("G_M_M_UNIDUSTER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_SDTICKETSELLER_01", GetSpawnPed("S_M_M_SDTICKETSELLER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_MagicLantern_01", GetSpawnPed("S_M_M_MagicLantern_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_GrizzledJon", GetSpawnPed("CS_GrizzledJon")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_VALCRIMINALS_01", GetSpawnPed("A_M_M_VALCRIMINALS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ASBMINER_02", GetSpawnPed("A_M_M_ASBMINER_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_Y_ASBMINER_02", GetSpawnPed("A_M_Y_ASBMINER_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ASBMINER_04", GetSpawnPed("A_M_M_ASBMINER_04")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_Y_ASBMINER_04", GetSpawnPed("A_M_Y_ASBMINER_04")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ASBMINER_03", GetSpawnPed("A_M_M_ASBMINER_03")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_Y_ASBMINER_03", GetSpawnPed("A_M_Y_ASBMINER_03")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_JamesonGuard_01", GetSpawnPed("A_M_M_JamesonGuard_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_ASBSHERIFF_01", GetSpawnPed("U_M_O_ASBSHERIFF_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RkrFancyDRIVERS_01", GetSpawnPed("A_M_M_RkrFancyDRIVERS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RkrFancyTravellers_01", GetSpawnPed("A_M_M_RkrFancyTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_RkrFancyTravellers_01", GetSpawnPed("A_F_M_RkrFancyTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_CornwallGuard_01", GetSpawnPed("S_M_M_CornwallGuard_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UniCornwallGoons_01", GetSpawnPed("G_M_M_UniCornwallGoons_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_CRDHOMESTEADTENANT_01", GetSpawnPed("U_M_M_CRDHOMESTEADTENANT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_CRDHOMESTEADTENANT_02", GetSpawnPed("U_M_M_CRDHOMESTEADTENANT_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_PSHRANCHER_01", GetSpawnPed("U_M_O_PSHRANCHER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_CAJHOMESTEAD_01", GetSpawnPed("U_M_O_CAJHOMESTEAD_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_Y_CAJHOMESTEAD_01", GetSpawnPed("U_M_Y_CAJHOMESTEAD_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_CAJHOMESTEAD_01", GetSpawnPed("U_M_M_CAJHOMESTEAD_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_DOROETHEAWICKLOW", GetSpawnPed("CS_DOROETHEAWICKLOW")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_AmbientSDPolice_01", GetSpawnPed("S_M_M_AmbientSDPolice_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_SDObeseMen_01", GetSpawnPed("A_M_M_SDObeseMen_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_SDObeseWomen_01", GetSpawnPed("A_F_M_SDObeseWomen_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_NBXShadyDealer_01", GetSpawnPed("U_M_M_NBXShadyDealer_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_WapTownfolk_01", GetSpawnPed("A_F_M_WapTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_SDLABORERS_02", GetSpawnPed("A_M_M_SDLABORERS_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_Y_NBXSTREETKIDS_01", GetSpawnPed("A_M_Y_NBXSTREETKIDS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_LowerSDTownfolk_02", GetSpawnPed("A_M_M_LowerSDTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_LowerSDTownfolk_01", GetSpawnPed("A_M_M_LowerSDTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_Y_NbxStreetKids_Slums_01", GetSpawnPed("A_M_Y_NbxStreetKids_Slums_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_Y_SDStreetKids_Slums_02", GetSpawnPed("A_M_Y_SDStreetKids_Slums_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_SDDockWorkers_02", GetSpawnPed("A_M_M_SDDockWorkers_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_SDDockForeman_01", GetSpawnPed("A_M_M_SDDockForeman_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_NbxSlums_01", GetSpawnPed("A_F_M_NbxSlums_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_SDSlums_02", GetSpawnPed("A_F_M_SDSlums_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_NbxSlums_01", GetSpawnPed("A_M_M_NbxSlums_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_SDSlums_02", GetSpawnPed("A_M_M_SDSlums_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_O_SDUpperClass_01", GetSpawnPed("A_M_O_SDUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_NbxUpperClass_01", GetSpawnPed("A_F_M_NbxUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_O_SDUpperClass_01", GetSpawnPed("A_F_O_SDUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_MiddleSDTownfolk_01", GetSpawnPed("A_M_M_MiddleSDTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_MiddleSDTownfolk_02", GetSpawnPed("A_M_M_MiddleSDTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_MiddleSDTownfolk_03", GetSpawnPed("A_M_M_MiddleSDTownfolk_03")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_MiddleSDTownfolk_01", GetSpawnPed("A_F_M_MiddleSDTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_MiddleSDTownfolk_02", GetSpawnPed("A_F_M_MiddleSDTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_LowerSDTownfolk_01", GetSpawnPed("A_F_M_LowerSDTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_LowerSDTownfolk_02", GetSpawnPed("A_F_M_LowerSDTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_LowerSDTownfolk_03", GetSpawnPed("A_F_M_LowerSDTownfolk_03")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_SDChinatown_01", GetSpawnPed("A_F_M_SDChinatown_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_O_SDChinatown_01", GetSpawnPed("A_F_O_SDChinatown_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_SDFancyWhore_01", GetSpawnPed("A_F_M_SDFancyWhore_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UNIBRONTEGOONS_01", GetSpawnPed("G_M_M_UNIBRONTEGOONS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_SDChinatown_01", GetSpawnPed("A_M_M_SDChinatown_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_O_SDChinatown_01", GetSpawnPed("A_M_O_SDChinatown_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_VALGUNSMITH_01", GetSpawnPed("U_M_M_VALGUNSMITH_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_VALGENSTOREOWNER_01", GetSpawnPed("U_M_M_VALGENSTOREOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ValButcher_01", GetSpawnPed("U_M_M_ValButcher_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_VALTOWNFOLK_01", GetSpawnPed("A_M_M_VALTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_VALDOCTOR_01", GetSpawnPed("U_M_M_VALDOCTOR_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_BANKCLERK_01", GetSpawnPed("S_M_M_BANKCLERK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ValHotelOwner_01", GetSpawnPed("U_M_M_ValHotelOwner_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_VALBARTENDER_01", GetSpawnPed("U_M_M_VALBARTENDER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_VALBARBER_01", GetSpawnPed("U_M_M_VALBARBER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_ValBartender_01", GetSpawnPed("U_M_O_ValBartender_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_NBXBARTENDER_02", GetSpawnPed("U_M_M_NBXBARTENDER_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BLWUPPERCLASS_01", GetSpawnPed("A_M_M_BLWUPPERCLASS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_NBXBARTENDER_01", GetSpawnPed("U_M_M_NBXBARTENDER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_MIDDLESDTOWNFOLK_01", GetSpawnPed("A_M_M_MIDDLESDTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_NBXGENERALSTOREOWNER_01", GetSpawnPed("U_M_M_NBXGENERALSTOREOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_NBXSHADYDEALER_01", GetSpawnPed("U_M_M_NBXSHADYDEALER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_TAILOR_01", GetSpawnPed("S_M_M_TAILOR_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_NBXGUNSMITH_01", GetSpawnPed("U_M_M_NBXGUNSMITH_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_SDDOCTOR_01", GetSpawnPed("CS_SDDOCTOR_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_LIVERYWORKER_01", GetSpawnPed("S_M_M_LIVERYWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_MarketVendor_01", GetSpawnPed("S_M_M_MarketVendor_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_SDPhotographer_01", GetSpawnPed("U_M_M_SDPhotographer_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_STRGENSTOREOWNER_01", GetSpawnPed("U_M_M_STRGENSTOREOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_STRFREIGHTSTATIONOWNER_01", GetSpawnPed("U_M_M_STRFREIGHTSTATIONOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ASBGUNSMITH_01", GetSpawnPed("U_M_M_ASBGUNSMITH_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_SDTRAPPER_01", GetSpawnPed("U_M_M_SDTRAPPER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_TRAINSTATIONWORKER_01", GetSpawnPed("S_M_M_TRAINSTATIONWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_LAGTOWNFOLK_01", GetSpawnPed("A_F_M_LAGTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_SKPGUARD_01", GetSpawnPed("S_M_M_SKPGUARD_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_SKPPRISONER_01", GetSpawnPed("A_M_M_SKPPRISONER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_F_M_LagMother_01", GetSpawnPed("U_F_M_LagMother_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_O_LagTownfolk_01", GetSpawnPed("A_F_O_LagTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_O_LagTownfolk_01", GetSpawnPed("A_M_O_LagTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RHDFOREMAN_01", GetSpawnPed("A_M_M_RHDFOREMAN_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ORPGUARD_01", GetSpawnPed("U_M_M_ORPGUARD_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_ABE", GetSpawnPed("CS_ABE")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_DavidGeddes", GetSpawnPed("CS_DavidGeddes")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_ANGUSGEDDES", GetSpawnPed("CS_ANGUSGEDDES")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_DUNCANGEDDES", GetSpawnPed("CS_DUNCANGEDDES")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_MRSGEDDES", GetSpawnPed("CS_MRSGEDDES")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UNIMOUNTAINMEN_01", GetSpawnPed("G_M_M_UNIMOUNTAINMEN_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_LagTownfolk_01", GetSpawnPed("A_F_M_LagTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_ThomasDown", GetSpawnPed("CS_ThomasDown")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_ArchieDown", GetSpawnPed("CS_ArchieDown")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_EDITHDOWN", GetSpawnPed("CS_EDITHDOWN")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_F_M_MaPWorker_01", GetSpawnPed("S_F_M_MaPWorker_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_StrTownfolk_01", GetSpawnPed("A_M_M_StrTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_STRLABORER_01", GetSpawnPed("A_M_M_STRLABORER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BynRoughTravellers_01", GetSpawnPed("A_M_M_BynRoughTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DOGPOODLE_01", GetSpawnPed("A_C_DOGPOODLE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_RHDCOWPOKE_01", GetSpawnPed("S_M_M_RHDCOWPOKE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_UniButchers_01", GetSpawnPed("S_M_M_UniButchers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_Y_NewspaperBoy_01", GetSpawnPed("S_M_Y_NewspaperBoy_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_RhdUpperClass_01", GetSpawnPed("A_F_M_RhdUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_RhdTownfolk_02", GetSpawnPed("A_F_M_RhdTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("a_m_m_rhdtownfolk_01_laborer", GetSpawnPed("a_m_m_rhdtownfolk_01_laborer")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_RHDTOWNFOLK_01", GetSpawnPed("A_F_M_RHDTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_RHDBARTENDER_01", GetSpawnPed("U_M_M_RHDBARTENDER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_RHDGUNSMITH_01", GetSpawnPed("U_M_M_RHDGUNSMITH_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_RHDGENSTOREOWNER_01", GetSpawnPed("U_M_M_RHDGENSTOREOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_RHDGENSTOREOWNER_02", GetSpawnPed("U_M_M_RHDGENSTOREOWNER_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_RHDSHERIFF_01", GetSpawnPed("U_M_M_RHDSHERIFF_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_RHDTRAINSTATIONWORKER_01", GetSpawnPed("U_M_M_RHDTRAINSTATIONWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_RHDPROSTITUTE_01", GetSpawnPed("A_F_M_RHDPROSTITUTE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RHDObeseMen_01", GetSpawnPed("A_M_M_RHDObeseMen_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RhdUpperClass_01", GetSpawnPed("A_M_M_RhdUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RkrRoughTravellers_01", GetSpawnPed("A_M_M_RkrRoughTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DOGCATAHOULACUR_01", GetSpawnPed("A_C_DOGCATAHOULACUR_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_VHTTOWNFOLK_01", GetSpawnPed("A_F_M_VHTTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_VHTTHUG_01", GetSpawnPed("A_M_M_VHTTHUG_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_VHTSTATIONCLERK_01", GetSpawnPed("U_M_M_VHTSTATIONCLERK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_VHTEXOTICSHOPKEEPER_01", GetSpawnPed("U_M_O_VHTEXOTICSHOPKEEPER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_F_M_VhTBartender_01", GetSpawnPed("U_F_M_VhTBartender_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_HtlFancyDRIVERS_01", GetSpawnPed("A_M_M_HtlFancyDRIVERS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_HtlFancyTravellers_01", GetSpawnPed("A_M_M_HtlFancyTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_HtlFancyTravellers_01", GetSpawnPed("A_F_M_HtlFancyTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_BARBER_01", GetSpawnPed("S_M_M_BARBER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_UNIBUTCHERS_01", GetSpawnPed("S_M_M_UNIBUTCHERS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_BLWCOWPOKE_01", GetSpawnPed("S_M_M_BLWCOWPOKE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BLWObeseMen_01", GetSpawnPed("A_M_M_BLWObeseMen_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_O_BlWUpperClass_01", GetSpawnPed("A_M_O_BlWUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_BlWUpperClass_01", GetSpawnPed("A_F_M_BlWUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_O_BlWUpperClass_01", GetSpawnPed("A_F_O_BlWUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BlWLaborer_02", GetSpawnPed("A_M_M_BlWLaborer_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BlWLaborer_01", GetSpawnPed("A_M_M_BlWLaborer_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BlWForeman_01", GetSpawnPed("A_M_M_BlWForeman_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_BlWTownfolk_02", GetSpawnPed("A_F_M_BlWTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_BlWTownfolk_01", GetSpawnPed("A_F_M_BlWTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_AmbientBlWPolice_01", GetSpawnPed("S_M_M_AmbientBlWPolice_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_FussarHenchman_01", GetSpawnPed("S_M_M_FussarHenchman_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_GuaTownfolk_01", GetSpawnPed("A_F_M_GuaTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_O_GuaTownfolk_01", GetSpawnPed("A_F_O_GuaTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_GuaTownfolk_01", GetSpawnPed("A_M_M_GuaTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_O_GuaTownfolk_01", GetSpawnPed("A_M_O_GuaTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_NicholasTimmins", GetSpawnPed("CS_NicholasTimmins")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_STRFANCYTOURIST_01", GetSpawnPed("A_M_M_STRFANCYTOURIST_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_BiVFancyTravellers_01", GetSpawnPed("A_F_M_BiVFancyTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_STRTOWNFOLK_01", GetSpawnPed("A_F_M_STRTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_UNIGUNSLINGER_01", GetSpawnPed("A_M_M_UNIGUNSLINGER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_StrGenStoreOwner_01", GetSpawnPed("U_M_M_StrGenStoreOwner_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_STRWELCOMECENTER_01", GetSpawnPed("U_M_M_STRWELCOMECENTER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_STRSHERRIFF_01", GetSpawnPed("U_M_M_STRSHERRIFF_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_StrFreightStationOwner_01", GetSpawnPed("U_M_M_StrFreightStationOwner_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UNICRIMINALS_01", GetSpawnPed("G_M_M_UNICRIMINALS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UNICRIMINALS_02", GetSpawnPed("G_M_M_UNICRIMINALS_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BTCObeseMen_01", GetSpawnPed("A_M_M_BTCObeseMen_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_BTCObeseWomen_01", GetSpawnPed("A_F_M_BTCObeseWomen_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_AsbTownfolk_01", GetSpawnPed("A_M_M_AsbTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_AsbTownfolk_01", GetSpawnPed("A_F_M_AsbTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_BTCHILLBILLY_01", GetSpawnPed("A_F_M_BTCHILLBILLY_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_O_BTCHILLBILLY_01", GetSpawnPed("A_F_O_BTCHILLBILLY_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BTCHILLBILLY_01", GetSpawnPed("A_M_M_BTCHILLBILLY_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UniBraithwaites_01", GetSpawnPed("G_M_M_UniBraithwaites_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_CmrCivilwarcommando_01", GetSpawnPed("U_M_O_CmrCivilwarcommando_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_Army_01", GetSpawnPed("S_M_M_Army_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_BWMSTABLEHAND_01", GetSpawnPed("U_M_M_BWMSTABLEHAND_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_CGHWORKER_01", GetSpawnPed("S_M_M_CGHWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UniGrays_01", GetSpawnPed("G_M_M_UniGrays_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_O_UniExConfeds_01", GetSpawnPed("G_M_O_UniExConfeds_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_Y_UniExConfeds_01", GetSpawnPed("G_M_Y_UniExConfeds_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("G_M_M_UNIINBRED_01", GetSpawnPed("G_M_M_UNIINBRED_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_AberdeenSister", GetSpawnPed("CS_AberdeenSister")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_GriRoughTravellers_01", GetSpawnPed("A_M_M_GriRoughTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_ValTownfolk_01", GetSpawnPed("A_F_M_ValTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_F_O_WTCTOWNFOLK_01", GetSpawnPed("U_F_O_WTCTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_BLWTRAINSTATIONWORKER_01", GetSpawnPed("U_M_M_BLWTRAINSTATIONWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_BLWPHOTOGRAPHER", GetSpawnPed("CS_BLWPHOTOGRAPHER")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BlWTownfolk_01", GetSpawnPed("A_M_M_BlWTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_BLWPOLICECHIEF_01", GetSpawnPed("U_M_O_BLWPOLICECHIEF_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_Tailor_01", GetSpawnPed("S_M_M_Tailor_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_BankClerk_01", GetSpawnPed("S_M_M_BankClerk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_BLWBARTENDER_01", GetSpawnPed("U_M_O_BLWBARTENDER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_BLWGENERALSTOREOWNER_01", GetSpawnPed("U_M_O_BLWGENERALSTOREOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_TumDeputies_01", GetSpawnPed("S_M_M_TumDeputies_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_SHERIFFFREEMAN", GetSpawnPed("CS_SHERIFFFREEMAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_NEAROUGHTRAVELLERS_01", GetSpawnPed("A_M_M_NEAROUGHTRAVELLERS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_TumTownfolk_01", GetSpawnPed("A_M_M_TumTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_TumTownfolk_01", GetSpawnPed("A_F_M_TumTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_TumTownfolk_02", GetSpawnPed("A_M_M_TumTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_TumTownfolk_02", GetSpawnPed("A_F_M_TumTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_TUMBARTENDER_01", GetSpawnPed("U_M_M_TUMBARTENDER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_TUMBUTCHER_01", GetSpawnPed("U_M_M_TUMBUTCHER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_TUMGUNSMITH_01", GetSpawnPed("U_M_M_TUMGUNSMITH_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_F_M_TUMGENERALSTOREOWNER_01", GetSpawnPed("U_F_M_TUMGENERALSTOREOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ARMTOWNFOLK_01", GetSpawnPed("A_M_M_ARMTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RANCHERTRAVELERS_WARM_01", GetSpawnPed("A_M_M_RANCHERTRAVELERS_WARM_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_AmbientLawRural_01", GetSpawnPed("S_M_M_AmbientLawRural_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ArmCholeraCorpse_01", GetSpawnPed("A_M_M_ArmCholeraCorpse_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_ArmCholeraCorpse_01", GetSpawnPed("A_F_M_ArmCholeraCorpse_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ARMGENERALSTOREOWNER_01", GetSpawnPed("U_M_M_ARMGENERALSTOREOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_O_ARMBARTENDER_01", GetSpawnPed("U_M_O_ARMBARTENDER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ARMTRAINSTATIONWORKER_01", GetSpawnPed("U_M_M_ARMTRAINSTATIONWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_ARMUNDERTAKER_01", GetSpawnPed("U_M_M_ARMUNDERTAKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("RE_DEADBODIES_MALE", GetSpawnPed("RE_DEADBODIES_MALE")));
		spawnPedMenu->AddChildItem(new CMenuAction("RE_DEADBODIES_MALES_01", GetSpawnPed("RE_DEADBODIES_MALES_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_ArmTownfolk_01", GetSpawnPed("A_F_M_ArmTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_ArmTownfolk_02", GetSpawnPed("A_F_M_ArmTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ArmTownfolk_01", GetSpawnPed("A_M_M_ArmTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ArmTownfolk_02", GetSpawnPed("A_M_M_ArmTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_FAMILYTRAVELERS_WARM_01", GetSpawnPed("A_F_M_FAMILYTRAVELERS_WARM_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_WROBEL", GetSpawnPed("CS_WROBEL")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_CZPHOMESTEADFATHER_01", GetSpawnPed("U_M_M_CZPHOMESTEADFATHER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_F_Y_CZPHOMESTEADDAUGHTER_01", GetSpawnPed("U_F_Y_CZPHOMESTEADDAUGHTER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_Y_CZPHOMESTEADSON_01", GetSpawnPed("U_M_Y_CZPHOMESTEADSON_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_Y_CZPHOMESTEADSON_02", GetSpawnPed("U_M_Y_CZPHOMESTEADSON_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_Y_CZPHOMESTEADSON_03", GetSpawnPed("U_M_Y_CZPHOMESTEADSON_03")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_LRSHOMESTEADTENANT_01", GetSpawnPed("U_M_M_LRSHOMESTEADTENANT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_F_M_RKSHOMESTEADTENANT_01", GetSpawnPed("U_F_M_RKSHOMESTEADTENANT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_UNIEXCONFEDSBOUNTY_01", GetSpawnPed("U_M_M_UNIEXCONFEDSBOUNTY_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_WALGENERALSTOREOWNER_01", GetSpawnPed("U_M_M_WALGENERALSTOREOWNER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_TrainStationWorker_01", GetSpawnPed("S_M_M_TrainStationWorker_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("p_m_zero", GetSpawnPed("p_m_zero")));
		spawnPedMenu->AddChildItem(new CMenuAction("P_M_THREE", GetSpawnPed("P_M_THREE")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_KIERAN", GetSpawnPed("A_C_HORSE_GANG_KIERAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Dutch", GetSpawnPed("CS_Dutch")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_JackMarston", GetSpawnPed("CS_JackMarston")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_JACKMARSTON_TEEN", GetSpawnPed("CS_JACKMARSTON_TEEN")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_EagleFlies", GetSpawnPed("CS_EagleFlies")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Cleet", GetSpawnPed("CS_Cleet")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Joe", GetSpawnPed("CS_Joe")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_CREOLECAPTAIN", GetSpawnPed("CS_CREOLECAPTAIN")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_JosiahTrelawny", GetSpawnPed("CS_JosiahTrelawny")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_RevSwanson", GetSpawnPed("CS_RevSwanson")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_LeoStrauss", GetSpawnPed("CS_LeoStrauss")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_MrPearson", GetSpawnPed("CS_MrPearson")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Lenny", GetSpawnPed("CS_Lenny")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Sean", GetSpawnPed("CS_Sean")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_HoseaMatthews", GetSpawnPed("CS_HoseaMatthews")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_JavierEscuella", GetSpawnPed("CS_JavierEscuella")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_CharlesSmith", GetSpawnPed("CS_CharlesSmith")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Uncle", GetSpawnPed("CS_Uncle")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_BillWilliamson", GetSpawnPed("CS_BillWilliamson")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_MicahBell", GetSpawnPed("CS_MicahBell")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_JohnMarston", GetSpawnPed("CS_JohnMarston")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_AbigailRoberts", GetSpawnPed("CS_AbigailRoberts")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_MaryBeth", GetSpawnPed("CS_MaryBeth")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_MollyOshea", GetSpawnPed("CS_MollyOshea")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_SusanGrimshaw", GetSpawnPed("CS_SusanGrimshaw")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Karen", GetSpawnPed("CS_Karen")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Tilly", GetSpawnPed("CS_Tilly")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_MrsAdler", GetSpawnPed("CS_MrsAdler")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_HtlRoughTravellers_01", GetSpawnPed("A_M_M_HtlRoughTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_SclRoughTravellers_01", GetSpawnPed("A_M_M_SclRoughTravellers_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_LnSWorker_01", GetSpawnPed("U_M_M_LnSWorker_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_LnSWorker_02", GetSpawnPed("U_M_M_LnSWorker_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_LnSWorker_03", GetSpawnPed("U_M_M_LnSWorker_03")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_LnSWorker_04", GetSpawnPed("U_M_M_LnSWorker_04")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_RKFRANCHER_01", GetSpawnPed("U_M_M_RKFRANCHER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_Rancher_01", GetSpawnPed("A_M_M_Rancher_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_MFRRANCHER_01", GetSpawnPed("U_M_M_MFRRANCHER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("EA_LCMP_DOGS", GetSpawnPed("EA_LCMP_DOGS")));
		spawnPedMenu->AddChildItem(new CMenuAction("EA_LCMP_FOREMAN", GetSpawnPed("EA_LCMP_FOREMAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_BiVForeman_01", GetSpawnPed("U_M_M_BiVForeman_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("EA_HMSTD_FOREMAN", GetSpawnPed("EA_HMSTD_FOREMAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_HtlForeman_01", GetSpawnPed("U_M_M_HtlForeman_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("EA_HMSTD_WORKER_1", GetSpawnPed("EA_HMSTD_WORKER_1")));
		spawnPedMenu->AddChildItem(new CMenuAction("EA_HMSTD_WORKER_2", GetSpawnPed("EA_HMSTD_WORKER_2")));
		spawnPedMenu->AddChildItem(new CMenuAction("EA_HMSTD_MALE", GetSpawnPed("EA_HMSTD_MALE")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_HTLHusband_01", GetSpawnPed("U_M_M_HTLHusband_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("EA_HMSTD_FEMALE", GetSpawnPed("EA_HMSTD_FEMALE")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_F_M_HTLWife_01", GetSpawnPed("U_F_M_HTLWife_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("EA_RCAMP_FOREMAN", GetSpawnPed("EA_RCAMP_FOREMAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_RaCForeman_01", GetSpawnPed("U_M_M_RaCForeman_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_NbxUpperClass_01", GetSpawnPed("A_M_M_NbxUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BlWUpperClass_01", GetSpawnPed("A_M_M_BlWUpperClass_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_Kieran", GetSpawnPed("CS_Kieran")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RHDTOWNFOLK_02", GetSpawnPed("A_M_M_RHDTOWNFOLK_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_CKTWORKER_01", GetSpawnPed("S_M_M_CKTWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_STRLUMBERJACK_01", GetSpawnPed("S_M_M_STRLUMBERJACK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_RaCRailWorker_01", GetSpawnPed("S_M_M_RaCRailWorker_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_Y_RACRAILWORKER_01", GetSpawnPed("S_M_Y_RACRAILWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BIVWORKER_01", GetSpawnPed("A_M_M_BIVWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BLWTOWNFOLK_01", GetSpawnPed("A_M_M_BLWTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_MAPWORKER_01", GetSpawnPed("S_M_M_MAPWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_Y_HTLWORKER_01", GetSpawnPed("U_M_Y_HTLWORKER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_Y_HTLWORKER_02", GetSpawnPed("U_M_Y_HTLWORKER_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ASBMINER_01", GetSpawnPed("A_M_M_ASBMINER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_Y_ASBMINER_01", GetSpawnPed("A_M_Y_ASBMINER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_AberdeenPigFarmer", GetSpawnPed("CS_AberdeenPigFarmer")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_DORHOMESTEADHUSBAND_01", GetSpawnPed("U_M_M_DORHOMESTEADHUSBAND_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_EmRFarmHand_01", GetSpawnPed("A_M_M_EmRFarmHand_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_M_EMRFATHER_01", GetSpawnPed("U_M_M_EMRFATHER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("U_M_Y_EMRSON_01", GetSpawnPed("U_M_Y_EMRSON_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ValTownfolk_01", GetSpawnPed("A_M_M_ValTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ValFarmer_01", GetSpawnPed("A_M_M_ValFarmer_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ValTownfolk_02", GetSpawnPed("A_M_M_ValTownfolk_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_ValCowpoke_01", GetSpawnPed("S_M_M_ValCowpoke_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_ValLaborer_01", GetSpawnPed("A_M_M_ValLaborer_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_M_LiveryWorker_01", GetSpawnPed("S_M_M_LiveryWorker_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_NBXDOCKWORKERS_01", GetSpawnPed("A_M_M_NBXDOCKWORKERS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_NBXLABORERS_01", GetSpawnPed("A_M_M_NBXLABORERS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_LagTownfolk_01", GetSpawnPed("A_M_M_LagTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_BtcHillbilly_01", GetSpawnPed("A_M_M_BtcHillbilly_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_O_BTCHILLBILLY_01", GetSpawnPed("A_M_O_BTCHILLBILLY_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_VhtTownfolk_01", GetSpawnPed("A_M_M_VhtTownfolk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("CS_TomDickens", GetSpawnPed("CS_TomDickens")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_STRTOWNFOLK_01", GetSpawnPed("A_M_M_STRTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RHDTOWNFOLK_01", GetSpawnPed("A_M_M_RHDTOWNFOLK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_M_M_RhdForeman_01", GetSpawnPed("A_M_M_RhdForeman_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("S_M_Y_Army_01", GetSpawnPed("S_M_Y_Army_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_NbxWhore_01", GetSpawnPed("A_F_M_NbxWhore_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_VHTPROSTITUTE_01", GetSpawnPed("A_F_M_VHTPROSTITUTE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_F_M_VALPROSTITUTE_01", GetSpawnPed("A_F_M_VALPROSTITUTE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Cat_01", GetSpawnPed("A_C_Cat_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_CedarWaxwing_01", GetSpawnPed("A_C_CedarWaxwing_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Chipmunk_01", GetSpawnPed("A_C_Chipmunk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_CRAB_01", GetSpawnPed("A_C_CRAB_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Cormorant_01", GetSpawnPed("A_C_Cormorant_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_CarolinaParakeet_01", GetSpawnPed("A_C_CarolinaParakeet_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DogCatahoulaCur_01", GetSpawnPed("A_C_DogCatahoulaCur_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DOGHOBO_01", GetSpawnPed("A_C_DOGHOBO_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DOGHOUND_01", GetSpawnPed("A_C_DOGHOUND_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DogHusky_01", GetSpawnPed("A_C_DogHusky_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DOGRUFUS_01", GetSpawnPed("A_C_DOGRUFUS_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DOGBLUETICKCOONHOUND_01", GetSpawnPed("A_C_DOGBLUETICKCOONHOUND_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Donkey_01", GetSpawnPed("A_C_Donkey_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Elk_01", GetSpawnPed("A_C_Elk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHBULLHEADCAT_01_SM", GetSpawnPed("A_C_FISHBULLHEADCAT_01_SM")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHNORTHERNPIKE_01_LG", GetSpawnPed("A_C_FISHNORTHERNPIKE_01_LG")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHRAINBOWTROUT_01_MS", GetSpawnPed("A_C_FISHRAINBOWTROUT_01_MS")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHSALMONSOCKEYE_01_MS", GetSpawnPed("A_C_FISHSALMONSOCKEYE_01_MS")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_GILAMONSTER_01", GetSpawnPed("A_C_GILAMONSTER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Goat_01", GetSpawnPed("A_C_Goat_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANPAINT_GREYOVERO", GetSpawnPed("A_C_HORSE_AMERICANPAINT_GREYOVERO")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANSTANDARDBRED_PALOMINODAPPLE", GetSpawnPed("A_C_HORSE_AMERICANSTANDARDBRED_PALOMINODAPPLE")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANSTANDARDBRED_SILVERTAILBUCKSKIN", GetSpawnPed("A_C_HORSE_AMERICANSTANDARDBRED_SILVERTAILBUCKSKIN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_ANDALUSIAN_DARKBAY", GetSpawnPed("A_C_HORSE_ANDALUSIAN_DARKBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_ANDALUSIAN_ROSEGRAY", GetSpawnPed("A_C_HORSE_ANDALUSIAN_ROSEGRAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_APPALOOSA_BROWNLEOPARD", GetSpawnPed("A_C_HORSE_APPALOOSA_BROWNLEOPARD")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_APPALOOSA_LEOPARD", GetSpawnPed("A_C_HORSE_APPALOOSA_LEOPARD")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_ARABIAN_BLACK", GetSpawnPed("A_C_HORSE_ARABIAN_BLACK")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_ARABIAN_ROSEGREYBAY", GetSpawnPed("A_C_HORSE_ARABIAN_ROSEGREYBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_ARDENNES_BAYROAN", GetSpawnPed("A_C_HORSE_ARDENNES_BAYROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_ARDENNES_STRAWBERRYROAN", GetSpawnPed("A_C_HORSE_ARDENNES_STRAWBERRYROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_BELGIAN_BLONDCHESTNUT", GetSpawnPed("A_C_HORSE_BELGIAN_BLONDCHESTNUT")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_BELGIAN_MEALYCHESTNUT", GetSpawnPed("A_C_HORSE_BELGIAN_MEALYCHESTNUT")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_DUTCHWARMBLOOD_CHOCOLATEROAN", GetSpawnPed("A_C_HORSE_DUTCHWARMBLOOD_CHOCOLATEROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_DUTCHWARMBLOOD_SEALBROWN", GetSpawnPed("A_C_HORSE_DUTCHWARMBLOOD_SEALBROWN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_DUTCHWARMBLOOD_SOOTYBUCKSKIN", GetSpawnPed("A_C_HORSE_DUTCHWARMBLOOD_SOOTYBUCKSKIN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_HUNGARIANHALFBRED_DARKDAPPLEGREY", GetSpawnPed("A_C_HORSE_HUNGARIANHALFBRED_DARKDAPPLEGREY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_HUNGARIANHALFBRED_PIEBALDTOBIANO", GetSpawnPed("A_C_HORSE_HUNGARIANHALFBRED_PIEBALDTOBIANO")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MISSOURIFOXTROTTER_AMBERCHAMPAGNE", GetSpawnPed("A_C_HORSE_MISSOURIFOXTROTTER_AMBERCHAMPAGNE")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MISSOURIFOXTROTTER_SILVERDAPPLEPINTO", GetSpawnPed("A_C_HORSE_MISSOURIFOXTROTTER_SILVERDAPPLEPINTO")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_NOKOTA_REVERSEDAPPLEROAN", GetSpawnPed("A_C_HORSE_NOKOTA_REVERSEDAPPLEROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_SHIRE_DARKBAY", GetSpawnPed("A_C_HORSE_SHIRE_DARKBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_SHIRE_LIGHTGREY", GetSpawnPed("A_C_HORSE_SHIRE_LIGHTGREY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_SUFFOLKPUNCH_SORREL", GetSpawnPed("A_C_HORSE_SUFFOLKPUNCH_SORREL")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_SUFFOLKPUNCH_REDCHESTNUT", GetSpawnPed("A_C_HORSE_SUFFOLKPUNCH_REDCHESTNUT")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_FLAXENROAN", GetSpawnPed("A_C_HORSE_TENNESSEEWALKER_FLAXENROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_THOROUGHBRED_BRINDLE", GetSpawnPed("A_C_HORSE_THOROUGHBRED_BRINDLE")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_TURKOMAN_DARKBAY", GetSpawnPed("A_C_HORSE_TURKOMAN_DARKBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_TURKOMAN_GOLD", GetSpawnPed("A_C_HORSE_TURKOMAN_GOLD")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_TURKOMAN_SILVER", GetSpawnPed("A_C_HORSE_TURKOMAN_SILVER")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_BILL", GetSpawnPed("A_C_HORSE_GANG_BILL")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_CHARLES", GetSpawnPed("A_C_HORSE_GANG_CHARLES")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_DUTCH", GetSpawnPed("A_C_HORSE_GANG_DUTCH")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_HOSEA", GetSpawnPed("A_C_HORSE_GANG_HOSEA")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_JAVIER", GetSpawnPed("A_C_HORSE_GANG_JAVIER")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_JOHN", GetSpawnPed("A_C_HORSE_GANG_JOHN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_KAREN", GetSpawnPed("A_C_HORSE_GANG_KAREN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_LENNY", GetSpawnPed("A_C_HORSE_GANG_LENNY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_MICAH", GetSpawnPed("A_C_HORSE_GANG_MICAH")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_SADIE", GetSpawnPed("A_C_HORSE_GANG_SADIE")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_SEAN", GetSpawnPed("A_C_HORSE_GANG_SEAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_TRELAWNEY", GetSpawnPed("A_C_HORSE_GANG_TRELAWNEY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_UNCLE", GetSpawnPed("A_C_HORSE_GANG_UNCLE")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_SADIE_ENDLESSSUMMER", GetSpawnPed("A_C_HORSE_GANG_SADIE_ENDLESSSUMMER")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_CHARLES_ENDLESSSUMMER", GetSpawnPed("A_C_HORSE_GANG_CHARLES_ENDLESSSUMMER")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_GANG_UNCLE_ENDLESSSUMMER", GetSpawnPed("A_C_HORSE_GANG_UNCLE_ENDLESSSUMMER")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANPAINT_OVERO", GetSpawnPed("A_C_HORSE_AMERICANPAINT_OVERO")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANPAINT_TOBIANO", GetSpawnPed("A_C_HORSE_AMERICANPAINT_TOBIANO")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANPAINT_SPLASHEDWHITE", GetSpawnPed("A_C_HORSE_AMERICANPAINT_SPLASHEDWHITE")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANSTANDARDBRED_BLACK", GetSpawnPed("A_C_HORSE_AMERICANSTANDARDBRED_BLACK")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_AMERICANSTANDARDBRED_BUCKSKIN", GetSpawnPed("A_C_HORSE_AMERICANSTANDARDBRED_BUCKSKIN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_APPALOOSA_BLANKET", GetSpawnPed("A_C_HORSE_APPALOOSA_BLANKET")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_APPALOOSA_LEOPARDBLANKET", GetSpawnPed("A_C_HORSE_APPALOOSA_LEOPARDBLANKET")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_ARABIAN_WHITE", GetSpawnPed("A_C_HORSE_ARABIAN_WHITE")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_HUNGARIANHALFBRED_FLAXENCHESTNUT", GetSpawnPed("A_C_HORSE_HUNGARIANHALFBRED_FLAXENCHESTNUT")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MUSTANG_GRULLODUN", GetSpawnPed("A_C_HORSE_MUSTANG_GRULLODUN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MUSTANG_WILDBAY", GetSpawnPed("A_C_HORSE_MUSTANG_WILDBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MUSTANG_TIGERSTRIPEDBAY", GetSpawnPed("A_C_HORSE_MUSTANG_TIGERSTRIPEDBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_NOKOTA_BLUEROAN", GetSpawnPed("A_C_HORSE_NOKOTA_BLUEROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_NOKOTA_WHITEROAN", GetSpawnPed("A_C_HORSE_NOKOTA_WHITEROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_THOROUGHBRED_BLOODBAY", GetSpawnPed("A_C_HORSE_THOROUGHBRED_BLOODBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_THOROUGHBRED_DAPPLEGREY", GetSpawnPed("A_C_HORSE_THOROUGHBRED_DAPPLEGREY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HorseMule_01", GetSpawnPed("A_C_HorseMule_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Ox_01", GetSpawnPed("A_C_Ox_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_REDFOOTEDBOOBY_01", GetSpawnPed("A_C_REDFOOTEDBOOBY_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SHARKHAMMERHEAD_01", GetSpawnPed("A_C_SHARKHAMMERHEAD_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SharkTiger", GetSpawnPed("A_C_SharkTiger")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SHEEP_01", GetSpawnPed("A_C_SHEEP_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SNAKEBLACKTAILRATTLE_01", GetSpawnPed("A_C_SNAKEBLACKTAILRATTLE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_snakeferdelance_01", GetSpawnPed("A_C_snakeferdelance_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_ROSEATESPOONBILL_01", GetSpawnPed("A_C_ROSEATESPOONBILL_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_TURKEY_01", GetSpawnPed("A_C_TURKEY_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_WOODPECKER_02", GetSpawnPed("A_C_WOODPECKER_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_PIG_01", GetSpawnPed("A_C_PIG_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SNAKEWATER_01", GetSpawnPed("A_C_SNAKEWATER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SPARROW_01", GetSpawnPed("A_C_SPARROW_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Egret_01", GetSpawnPed("A_C_Egret_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_PARROT_01", GetSpawnPed("A_C_PARROT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_PRAIRIECHICKEN_01", GetSpawnPed("A_C_PRAIRIECHICKEN_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_BAT_01", GetSpawnPed("A_C_BAT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Heron_01", GetSpawnPed("A_C_Heron_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Oriole_01", GetSpawnPed("A_C_Oriole_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_BLUEJAY_01", GetSpawnPed("A_C_BLUEJAY_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_CARDINAL_01", GetSpawnPed("A_C_CARDINAL_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Duck_01", GetSpawnPed("A_C_Duck_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_PIGEON", GetSpawnPed("A_C_PIGEON")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_ROBIN_01", GetSpawnPed("A_C_ROBIN_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SONGBIRD_01", GetSpawnPed("A_C_SONGBIRD_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Woodpecker_01", GetSpawnPed("A_C_Woodpecker_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_IGUANA_01", GetSpawnPed("A_C_IGUANA_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_ROOSTER_01", GetSpawnPed("A_C_ROOSTER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SNAKEFERDELANCE_01", GetSpawnPed("A_C_SNAKEFERDELANCE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Armadillo_01", GetSpawnPed("A_C_Armadillo_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_IGUANADESERT_01", GetSpawnPed("A_C_IGUANADESERT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Quail_01", GetSpawnPed("A_C_Quail_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SNAKEREDBOA_01", GetSpawnPed("A_C_SNAKEREDBOA_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Chicken_01", GetSpawnPed("A_C_Chicken_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FROGBULL_01", GetSpawnPed("A_C_FROGBULL_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SQUIRREL_01", GetSpawnPed("A_C_SQUIRREL_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Toad_01", GetSpawnPed("A_C_Toad_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_TURTLESNAPPING_01", GetSpawnPed("A_C_TURTLESNAPPING_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Bull_01", GetSpawnPed("A_C_Bull_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Cow", GetSpawnPed("A_C_Cow")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_MUSKRAT_01", GetSpawnPed("A_C_MUSKRAT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_RAT_01", GetSpawnPed("A_C_RAT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SNAKE_01", GetSpawnPed("A_C_SNAKE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Beaver_01", GetSpawnPed("A_C_Beaver_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_PHEASANT_01", GetSpawnPed("A_C_PHEASANT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Rabbit_01", GetSpawnPed("A_C_Rabbit_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_TurkeyWild_01", GetSpawnPed("A_C_TurkeyWild_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_BigHornRam_01", GetSpawnPed("A_C_BigHornRam_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Buck_01", GetSpawnPed("A_C_Buck_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Buffalo_01", GetSpawnPed("A_C_Buffalo_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DEER_01", GetSpawnPed("A_C_DEER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_ELK_01", GetSpawnPed("A_C_ELK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_MOOSE_01", GetSpawnPed("A_C_MOOSE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_ProngHorn_01", GetSpawnPed("A_C_ProngHorn_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MORGAN_BAY", GetSpawnPed("A_C_HORSE_MORGAN_BAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MORGAN_BAYROAN", GetSpawnPed("A_C_HORSE_MORGAN_BAYROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MORGAN_FLAXENCHESTNUT", GetSpawnPed("A_C_HORSE_MORGAN_FLAXENCHESTNUT")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_MORGAN_PALOMINO", GetSpawnPed("A_C_HORSE_MORGAN_PALOMINO")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_KENTUCKYSADDLE_BLACK", GetSpawnPed("A_C_HORSE_KENTUCKYSADDLE_BLACK")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_KENTUCKYSADDLE_CHESTNUTPINTO", GetSpawnPed("A_C_HORSE_KENTUCKYSADDLE_CHESTNUTPINTO")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_KENTUCKYSADDLE_GREY", GetSpawnPed("A_C_HORSE_KENTUCKYSADDLE_GREY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_KENTUCKYSADDLE_SILVERBAY", GetSpawnPed("A_C_HORSE_KENTUCKYSADDLE_SILVERBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_BLACKRABICANO", GetSpawnPed("A_C_HORSE_TENNESSEEWALKER_BLACKRABICANO")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_CHESTNUT", GetSpawnPed("A_C_HORSE_TENNESSEEWALKER_CHESTNUT")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_DAPPLEBAY", GetSpawnPed("A_C_HORSE_TENNESSEEWALKER_DAPPLEBAY")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HORSE_TENNESSEEWALKER_REDROAN", GetSpawnPed("A_C_HORSE_TENNESSEEWALKER_REDROAN")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_BEAR_01", GetSpawnPed("A_C_BEAR_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DOGAMERICANFOXHOUND_01", GetSpawnPed("A_C_DOGAMERICANFOXHOUND_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DOGCOLLIE_01", GetSpawnPed("A_C_DOGCOLLIE_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DogAustralianSheperd_01", GetSpawnPed("A_C_DogAustralianSheperd_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DogChesBayRetriever_01", GetSpawnPed("A_C_DogChesBayRetriever_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DogLab_01", GetSpawnPed("A_C_DogLab_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DogStreet_01", GetSpawnPed("A_C_DogStreet_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DogBlueTickCoonHound_01", GetSpawnPed("A_C_DogBlueTickCoonHound_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DogHound_01", GetSpawnPed("A_C_DogHound_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_TURTLESEA_01", GetSpawnPed("A_C_TURTLESEA_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HAWK_01", GetSpawnPed("A_C_HAWK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_DUCK_01", GetSpawnPed("A_C_DUCK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_LOON_01", GetSpawnPed("A_C_LOON_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_CORMORANT_01", GetSpawnPed("A_C_CORMORANT_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_GOOSECANADA_01", GetSpawnPed("A_C_GOOSECANADA_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_HERON_01", GetSpawnPed("A_C_HERON_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_EGRET_01", GetSpawnPed("A_C_EGRET_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_CraneWhooping_01", GetSpawnPed("A_C_CraneWhooping_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_PELICAN_01", GetSpawnPed("A_C_PELICAN_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Badger_01", GetSpawnPed("A_C_Badger_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_BOAR_01", GetSpawnPed("A_C_BOAR_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_JAVELINA_01", GetSpawnPed("A_C_JAVELINA_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_OWL_01", GetSpawnPed("A_C_OWL_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_PANTHER_01", GetSpawnPed("A_C_PANTHER_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_POSSUM_01", GetSpawnPed("A_C_POSSUM_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Raccoon_01", GetSpawnPed("A_C_Raccoon_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SKUNK_01", GetSpawnPed("A_C_SKUNK_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Alligator_01", GetSpawnPed("A_C_Alligator_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Alligator_02", GetSpawnPed("A_C_Alligator_02")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Alligator_03", GetSpawnPed("A_C_Alligator_03")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Bear_01", GetSpawnPed("A_C_Bear_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_BearBlack_01", GetSpawnPed("A_C_BearBlack_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Boar_01", GetSpawnPed("A_C_Boar_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_CALIFORNIACONDOR_01", GetSpawnPed("A_C_CALIFORNIACONDOR_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Cougar_01", GetSpawnPed("A_C_Cougar_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Coyote_01", GetSpawnPed("A_C_Coyote_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Crow_01", GetSpawnPed("A_C_Crow_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Eagle_01", GetSpawnPed("A_C_Eagle_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Fox_01", GetSpawnPed("A_C_Fox_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Hawk_01", GetSpawnPed("A_C_Hawk_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Owl_01", GetSpawnPed("A_C_Owl_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Panther_01", GetSpawnPed("A_C_Panther_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_RAVEN_01", GetSpawnPed("A_C_RAVEN_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_SEAGULL_01", GetSpawnPed("A_C_SEAGULL_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Vulture_01", GetSpawnPed("A_C_Vulture_01")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Wolf", GetSpawnPed("A_C_Wolf")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Wolf_Medium", GetSpawnPed("A_C_Wolf_Medium")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_Wolf_Small", GetSpawnPed("A_C_Wolf_Small")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FishMuskie_01_lg", GetSpawnPed("A_C_FishMuskie_01_lg")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHLAKESTURGEON_01_LG", GetSpawnPed("A_C_FISHLAKESTURGEON_01_LG")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHLONGNOSEGAR_01_LG", GetSpawnPed("A_C_FISHLONGNOSEGAR_01_LG")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHCHANNELCATFISH_01_LG", GetSpawnPed("A_C_FISHCHANNELCATFISH_01_LG")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHBLUEGIL_01_SM", GetSpawnPed("A_C_FISHBLUEGIL_01_SM")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHPERCH_01_SM", GetSpawnPed("A_C_FISHPERCH_01_SM")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHCHAINPICKEREL_01_SM", GetSpawnPed("A_C_FISHCHAINPICKEREL_01_SM")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHROCKBASS_01_SM", GetSpawnPed("A_C_FISHROCKBASS_01_SM")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHREDFINPICKEREL_01_SM", GetSpawnPed("A_C_FISHREDFINPICKEREL_01_SM")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHBLUEGIL_01_MS", GetSpawnPed("A_C_FISHBLUEGIL_01_MS")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHPERCH_01_MS", GetSpawnPed("A_C_FISHPERCH_01_MS")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHREDFINPICKEREL_01_MS", GetSpawnPed("A_C_FISHREDFINPICKEREL_01_MS")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHROCKBASS_01_MS", GetSpawnPed("A_C_FISHROCKBASS_01_MS")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHSMALLMOUTHBASS_01_MS", GetSpawnPed("A_C_FISHSMALLMOUTHBASS_01_MS")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHBULLHEADCAT_01_MS", GetSpawnPed("A_C_FISHBULLHEADCAT_01_MS")));
		spawnPedMenu->AddChildItem(new CMenuAction("A_C_FISHLARGEMOUTHBASS_01_MS", GetSpawnPed("A_C_FISHLARGEMOUTHBASS_01_MS")));

		CSubMenu* teleportMenu = new CSubMenu("TELEPORT", mainMenu);
		teleportMenu->AddChildItem(new CMenuAction("Saint Denis", GetTeleportPlayer(2700.1, -1403.39, 46.6373)));
		teleportMenu->AddChildItem(new CMenuAction("Van Horn", GetTeleportPlayer(2962.82, 583.162, 44.2948)));
		teleportMenu->AddChildItem(new CMenuAction("Annesburg", GetTeleportPlayer(2941.17, 1358.08, 44.0665)));
		teleportMenu->AddChildItem(new CMenuAction("Maclean's House", GetTeleportPlayer(2252.3, -135.647, 46.2262)));
		teleportMenu->AddChildItem(new CMenuAction("Hagen Orchards", GetTeleportPlayer(2069.06, -861.575, 42.4468)));
		teleportMenu->AddChildItem(new CMenuAction("Caliga Hall", GetTeleportPlayer(1797.61, -1352.64, 43.8385)));
		teleportMenu->AddChildItem(new CMenuAction("Braithwaite Manor", GetTeleportPlayer(889.869, -1910.26, 45.2703)));
		teleportMenu->AddChildItem(new CMenuAction("Emerald Ranch", GetTeleportPlayer(1424.09, 316.904, 88.6065)));
		teleportMenu->AddChildItem(new CMenuAction("Scarlett Meadows", GetTeleportPlayer(1211.79, -201.815, 101.436)));
		teleportMenu->AddChildItem(new CMenuAction("Alone Tree", GetTeleportPlayer(491.451, -307.623, 143.75)));
		teleportMenu->AddChildItem(new CMenuAction("Flatneck Station", GetTeleportPlayer(-344.127, -363.465, 88.0377)));
		teleportMenu->AddChildItem(new CMenuAction("Wallace Station", GetTeleportPlayer(-1308.38, 400.834, 95.3829)));
		teleportMenu->AddChildItem(new CMenuAction("Riggs Station", GetTeleportPlayer(-1087.97, -585.786, 81.4831)));
		teleportMenu->AddChildItem(new CMenuAction("Valentine", GetTeleportPlayer(-262.849, 793.404, 118.587)));
		teleportMenu->AddChildItem(new CMenuAction("Chadwick Farm", GetTeleportPlayer(-391.389, 916.105, 117.644)));
		teleportMenu->AddChildItem(new CMenuAction("Fort Wallace", GetTeleportPlayer(366.483, 1456.73, 178.916)));
		teleportMenu->AddChildItem(new CMenuAction("Downes Ranch", GetTeleportPlayer(-822.636, 325.741, 95.2731)));
		teleportMenu->AddChildItem(new CMenuAction("Strawberry", GetTeleportPlayer(-1815.63, -396.749, 161.602)));
		teleportMenu->AddChildItem(new CMenuAction("Big Valley", GetTeleportPlayer(-1819.9, -599.968, 154.616)));
		teleportMenu->AddChildItem(new CMenuAction("Holding Camp", GetTeleportPlayer(-1588.19, -936.054, 84.1072)));
		teleportMenu->AddChildItem(new CMenuAction("Blackwater", GetTeleportPlayer(-858.065, -1337.73, 44.4866)));
		teleportMenu->AddChildItem(new CMenuAction("Great Plains", GetTeleportPlayer(-898.997, -1654.69, 68.5928)));
		teleportMenu->AddChildItem(new CMenuAction("Quaker's Cove", GetTeleportPlayer(-1191.3, -1950.71, 43.5789)));
		teleportMenu->AddChildItem(new CMenuAction("Thieves Landing", GetTeleportPlayer(-1452.17, -2329.4, 42.9603)));

		CSubMenu* weatherMenu = new CSubMenu("WEATHER", mainMenu);
		weatherMenu->AddChildItem(new CMenuAction("OVERCAST", GetSetWeather("OVERCAST")));
		weatherMenu->AddChildItem(new CMenuAction("RAIN", GetSetWeather("RAIN")));
		weatherMenu->AddChildItem(new CMenuAction("FOG", GetSetWeather("FOG")));
		weatherMenu->AddChildItem(new CMenuAction("SNOWLIGHT", GetSetWeather("SNOWLIGHT")));
		weatherMenu->AddChildItem(new CMenuAction("THUNDER", GetSetWeather("THUNDER")));
		weatherMenu->AddChildItem(new CMenuAction("BLIZZARD", GetSetWeather("BLIZZARD")));
		weatherMenu->AddChildItem(new CMenuAction("SNOW", GetSetWeather("SNOW")));
		weatherMenu->AddChildItem(new CMenuAction("MISTY", GetSetWeather("MISTY")));
		weatherMenu->AddChildItem(new CMenuAction("SUNNY", GetSetWeather("SUNNY")));
		weatherMenu->AddChildItem(new CMenuAction("HIGHPRESSURE", GetSetWeather("HIGHPRESSURE")));
		weatherMenu->AddChildItem(new CMenuAction("CLEARING", GetSetWeather("CLEARING")));
		weatherMenu->AddChildItem(new CMenuAction("SLEET", GetSetWeather("SLEET")));
		weatherMenu->AddChildItem(new CMenuAction("DRIZZLE", GetSetWeather("DRIZZLE")));
		weatherMenu->AddChildItem(new CMenuAction("SHOWER", GetSetWeather("SHOWER")));
		weatherMenu->AddChildItem(new CMenuAction("SNOWCLEARING", GetSetWeather("SNOWCLEARING")));
		weatherMenu->AddChildItem(new CMenuAction("OVERCASTDARK", GetSetWeather("OVERCASTDARK")));
		weatherMenu->AddChildItem(new CMenuAction("THUNDERSTORM", GetSetWeather("THUNDERSTORM")));
		weatherMenu->AddChildItem(new CMenuAction("SANDSTORM", GetSetWeather("SANDSTORM")));
		weatherMenu->AddChildItem(new CMenuAction("HURRICANE", GetSetWeather("HURRICANE")));
		weatherMenu->AddChildItem(new CMenuAction("HAIL", GetSetWeather("HAIL")));
		weatherMenu->AddChildItem(new CMenuAction("WHITEOUT", GetSetWeather("WHITEOUT")));
		weatherMenu->AddChildItem(new CMenuAction("GROUNDBLIZZARD", GetSetWeather("GROUNDBLIZZARD")));

		CSubMenu* timeMenu = new CSubMenu("TIME", mainMenu);
		timeMenu->AddChildItem(new CMenuAction("+ 4 hours", GetAddToClockTime(4, 0, 0)));
		timeMenu->AddChildItem(new CMenuAction("+ 1 hour", GetAddToClockTime(1, 0, 0)));
		timeMenu->AddChildItem(new CMenuAction("+ 15 minutes", GetAddToClockTime(0, 15, 0)));
		timeMenu->AddChildItem(new CMenuAction("- 4 hours", GetAddToClockTime(-4, 0, 0)));
		timeMenu->AddChildItem(new CMenuAction("- 1 hour", GetAddToClockTime(-1, 0, 0)));
		timeMenu->AddChildItem(new CMenuAction("- 15 minutes", GetAddToClockTime(0, -15, 0)));


		mainMenu->AddChildItem(vehiclesMenu);
		mainMenu->AddChildItem(changePlayerModel);
		mainMenu->AddChildItem(spawnPedMenu);
		mainMenu->AddChildItem(teleportMenu);
		mainMenu->AddChildItem(weatherMenu);
		mainMenu->AddChildItem(timeMenu);
	}

	DLL_EXPORT void Tick()
	{
		TickCpp();
	}

	DLL_EXPORT void OnKeyDown(uint32_t key)
	{
		if (key == 0x72)
		{
			menuEnabled = !menuEnabled;
		}
		if (key == 0x26 && menuEnabled)
		{
			menuCursor--;
			if (menuCursor < 0)
				menuCursor = currentMenu->ChildCount() - (currentMenu->GetType() == eMenuType::SUB_MENU ? 0 : 1);
		}
		if (key == 0x28 && menuEnabled)
		{
			menuCursor++;
			int maxItems = currentMenu->ChildCount() + (currentMenu->GetType() == eMenuType::SUB_MENU ? 1 : 0);
			if (menuCursor >= maxItems)
				menuCursor = 0;
		}
		if (key == 0x21 && menuEnabled)
		{
			menuCursor -= 10;
			if (menuCursor < 0)
				menuCursor = currentMenu->ChildCount() - (currentMenu->GetType() == eMenuType::SUB_MENU ? 0 : 1);
		}
		if (key == 0x22 && menuEnabled)
		{
			menuCursor += 10;
			int maxItems = currentMenu->ChildCount() + (currentMenu->GetType() == eMenuType::SUB_MENU ? 1 : 0);
			if (menuCursor >= maxItems)
				menuCursor = 0;
		}
		if (key == 0x0D && menuEnabled)
		{
			int cursorPos = menuCursor;
			if (menuCursor == 0 && currentMenu->GetType() == eMenuType::SUB_MENU)
			{
				menuCursor = 0;
				currentMenu = currentMenu->GetParent();
				return;
			}

			if (currentMenu->GetType() == eMenuType::SUB_MENU)
				cursorPos--;
			
			IMenu* childItem = currentMenu->GetChildItems()[cursorPos];
			if (childItem->GetType() == eMenuType::MENU_ACTION)
			{
				CMenuAction* menuAction = (CMenuAction*)childItem;
				auto func = menuAction->GetActionFunc();
				func();
				return;
			}
			else if (childItem->GetType() == eMenuType::SUB_MENU)
			{
				menuCursor = 0;
				currentMenu = childItem;
			}
		}
		if (key == 0x08 && menuEnabled)
		{
			if (currentMenu->GetType() == eMenuType::SUB_MENU)
			{
				menuCursor = 0;
				currentMenu = currentMenu->GetParent();
				return;
			}
			if (currentMenu->GetType() == eMenuType::MAIN_MENU)
			{
				menuEnabled = false;
				return;
			}
		}
	}

	DLL_EXPORT void OnKeyUp(uint32_t key)
	{
	}
}

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
                     )
{
    switch (ul_reason_for_call)
    {
    case DLL_PROCESS_ATTACH:
	{
		std::wstring _moduleDir = GetModulePath(hModule);

		std::wstring logPath = _moduleDir + L"/log.txt";
		Log::Push(new Log::FileStream(logPath));
		break;
	}
    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
    case DLL_PROCESS_DETACH:
        break;
    }
    return TRUE;
}

